/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScore;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.curriculumcourse.domain.Course;
import org.drools.planner.examples.curriculumcourse.domain.Curriculum;
import org.drools.planner.examples.curriculumcourse.domain.Day;
import org.drools.planner.examples.curriculumcourse.domain.Lecture;
import org.drools.planner.examples.curriculumcourse.domain.Period;
import org.drools.planner.examples.curriculumcourse.domain.Room;
import org.drools.planner.examples.curriculumcourse.domain.Teacher;
import org.drools.planner.examples.curriculumcourse.domain.Timeslot;
import org.drools.planner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="CurriculumCourseSchedule")
public class CurriculumCourseSchedule
extends AbstractPersistable
implements Solution<HardAndSoftScore> {
    private String name;
    private List<Teacher> teacherList;
    private List<Curriculum> curriculumList;
    private List<Course> courseList;
    private List<Day> dayList;
    private List<Timeslot> timeslotList;
    private List<Period> periodList;
    private List<Room> roomList;
    private List<UnavailablePeriodPenalty> unavailablePeriodPenaltyList;
    private List<Lecture> lectureList;
    private HardAndSoftScore score;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Teacher> getTeacherList() {
        return this.teacherList;
    }

    public void setTeacherList(List<Teacher> teacherList) {
        this.teacherList = teacherList;
    }

    public List<Curriculum> getCurriculumList() {
        return this.curriculumList;
    }

    public void setCurriculumList(List<Curriculum> curriculumList) {
        this.curriculumList = curriculumList;
    }

    public List<Course> getCourseList() {
        return this.courseList;
    }

    public void setCourseList(List<Course> courseList) {
        this.courseList = courseList;
    }

    public List<Day> getDayList() {
        return this.dayList;
    }

    public void setDayList(List<Day> dayList) {
        this.dayList = dayList;
    }

    public List<Timeslot> getTimeslotList() {
        return this.timeslotList;
    }

    public void setTimeslotList(List<Timeslot> timeslotList) {
        this.timeslotList = timeslotList;
    }

    public List<Period> getPeriodList() {
        return this.periodList;
    }

    public void setPeriodList(List<Period> periodList) {
        this.periodList = periodList;
    }

    public List<Room> getRoomList() {
        return this.roomList;
    }

    public void setRoomList(List<Room> roomList) {
        this.roomList = roomList;
    }

    public List<UnavailablePeriodPenalty> getUnavailablePeriodPenaltyList() {
        return this.unavailablePeriodPenaltyList;
    }

    public void setUnavailablePeriodPenaltyList(List<UnavailablePeriodPenalty> unavailablePeriodPenaltyList) {
        this.unavailablePeriodPenaltyList = unavailablePeriodPenaltyList;
    }

    @PlanningEntityCollectionProperty
    public List<Lecture> getLectureList() {
        return this.lectureList;
    }

    public void setLectureList(List<Lecture> lectureList) {
        this.lectureList = lectureList;
    }

    @Override
    public HardAndSoftScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(HardAndSoftScore score) {
        this.score = score;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.addAll(this.teacherList);
        facts.addAll(this.curriculumList);
        facts.addAll(this.courseList);
        facts.addAll(this.dayList);
        facts.addAll(this.timeslotList);
        facts.addAll(this.periodList);
        facts.addAll(this.roomList);
        facts.addAll(this.unavailablePeriodPenaltyList);
        return facts;
    }

    public CurriculumCourseSchedule cloneSolution() {
        CurriculumCourseSchedule clone = new CurriculumCourseSchedule();
        clone.id = this.id;
        clone.name = this.name;
        clone.teacherList = this.teacherList;
        clone.curriculumList = this.curriculumList;
        clone.courseList = this.courseList;
        clone.dayList = this.dayList;
        clone.timeslotList = this.timeslotList;
        clone.periodList = this.periodList;
        clone.roomList = this.roomList;
        clone.unavailablePeriodPenaltyList = this.unavailablePeriodPenaltyList;
        ArrayList<Lecture> clonedLectureList = new ArrayList<Lecture>(this.lectureList.size());
        for (Lecture lecture : this.lectureList) {
            Lecture clonedLecture = lecture.clone();
            clonedLectureList.add(clonedLecture);
        }
        clone.lectureList = clonedLectureList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof CurriculumCourseSchedule)) {
            return false;
        }
        CurriculumCourseSchedule other = (CurriculumCourseSchedule)o;
        if (this.lectureList.size() != other.lectureList.size()) {
            return false;
        }
        Iterator<Lecture> it = this.lectureList.iterator();
        Iterator<Lecture> otherIt = other.lectureList.iterator();
        while (it.hasNext()) {
            Lecture otherLecture;
            Lecture lecture = it.next();
            if (lecture.solutionEquals(otherLecture = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (Lecture lecture : this.lectureList) {
            hashCodeBuilder.append(lecture.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

