/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.domain.solver;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.api.domain.entity.PlanningEntityDifficultyWeightFactory;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.curriculumcourse.domain.Course;
import org.drools.planner.examples.curriculumcourse.domain.CurriculumCourseSchedule;
import org.drools.planner.examples.curriculumcourse.domain.Lecture;
import org.drools.planner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;

public class LectureDifficultyWeightFactory
implements PlanningEntityDifficultyWeightFactory {
    public Comparable createDifficultyWeight(Solution solution, Object planningEntity) {
        CurriculumCourseSchedule schedule = (CurriculumCourseSchedule)solution;
        Lecture lecture = (Lecture)planningEntity;
        Course course = lecture.getCourse();
        int unavailablePeriodPenaltyCount = 0;
        for (UnavailablePeriodPenalty penalty : schedule.getUnavailablePeriodPenaltyList()) {
            if (!penalty.getCourse().equals(course)) continue;
            ++unavailablePeriodPenaltyCount;
        }
        return new LectureDifficultyWeight(lecture, unavailablePeriodPenaltyCount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LectureDifficultyWeight
    implements Comparable<LectureDifficultyWeight> {
        private final Lecture lecture;
        private final int unavailablePeriodPenaltyCount;

        public LectureDifficultyWeight(Lecture lecture, int unavailablePeriodPenaltyCount) {
            this.lecture = lecture;
            this.unavailablePeriodPenaltyCount = unavailablePeriodPenaltyCount;
        }

        @Override
        public int compareTo(LectureDifficultyWeight other) {
            Course course = this.lecture.getCourse();
            Course otherCourse = other.lecture.getCourse();
            return new CompareToBuilder().append(course.getCurriculumList().size(), otherCourse.getCurriculumList().size()).append(this.unavailablePeriodPenaltyCount, other.unavailablePeriodPenaltyCount).append(course.getLectureSize(), otherCourse.getLectureSize()).append(course.getStudentSize(), otherCourse.getStudentSize()).append(course.getMinWorkingDaySize(), otherCourse.getMinWorkingDaySize()).append((Object)this.lecture.getId(), (Object)other.lecture.getId()).toComparison();
        }
    }
}

