/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.traindesign.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScore;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.traindesign.domain.CarBlock;
import org.drools.planner.examples.traindesign.domain.CarBlockDesignation;
import org.drools.planner.examples.traindesign.domain.CrewSegment;
import org.drools.planner.examples.traindesign.domain.RailArc;
import org.drools.planner.examples.traindesign.domain.RailNode;
import org.drools.planner.examples.traindesign.domain.TrainDesignParametrization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="TrainDesign")
public class TrainDesign
extends AbstractPersistable
implements Solution<HardAndSoftScore> {
    private TrainDesignParametrization trainDesignParametrization;
    private List<RailNode> railNodeList;
    private List<RailArc> railArcList;
    private List<CarBlock> carBlockList;
    private List<CrewSegment> crewSegmentList;
    private List<CarBlockDesignation> carBlockDesignationList;
    private HardAndSoftScore score;

    public TrainDesignParametrization getTrainDesignParametrization() {
        return this.trainDesignParametrization;
    }

    public void setTrainDesignParametrization(TrainDesignParametrization trainDesignParametrization) {
        this.trainDesignParametrization = trainDesignParametrization;
    }

    public List<RailNode> getRailNodeList() {
        return this.railNodeList;
    }

    public void setRailNodeList(List<RailNode> railNodeList) {
        this.railNodeList = railNodeList;
    }

    public List<RailArc> getRailArcList() {
        return this.railArcList;
    }

    public void setRailArcList(List<RailArc> railArcList) {
        this.railArcList = railArcList;
    }

    public List<CarBlock> getCarBlockList() {
        return this.carBlockList;
    }

    public void setCarBlockList(List<CarBlock> carBlockList) {
        this.carBlockList = carBlockList;
    }

    public List<CrewSegment> getCrewSegmentList() {
        return this.crewSegmentList;
    }

    public void setCrewSegmentList(List<CrewSegment> crewSegmentList) {
        this.crewSegmentList = crewSegmentList;
    }

    @PlanningEntityCollectionProperty
    public List<CarBlockDesignation> getCarBlockDesignationList() {
        return this.carBlockDesignationList;
    }

    public void setCarBlockDesignationList(List<CarBlockDesignation> bedDesignationList) {
        this.carBlockDesignationList = bedDesignationList;
    }

    @Override
    public HardAndSoftScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(HardAndSoftScore score) {
        this.score = score;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.add(this.trainDesignParametrization);
        facts.addAll(this.railNodeList);
        facts.addAll(this.railArcList);
        facts.addAll(this.carBlockList);
        facts.addAll(this.crewSegmentList);
        return facts;
    }

    public TrainDesign cloneSolution() {
        TrainDesign clone = new TrainDesign();
        clone.id = this.id;
        clone.trainDesignParametrization = this.trainDesignParametrization;
        clone.railNodeList = this.railNodeList;
        clone.railArcList = this.railArcList;
        clone.carBlockList = this.carBlockList;
        clone.crewSegmentList = this.crewSegmentList;
        ArrayList<CarBlockDesignation> clonedCarBlockDesignationList = new ArrayList<CarBlockDesignation>(this.carBlockDesignationList.size());
        for (CarBlockDesignation bedDesignation : this.carBlockDesignationList) {
            CarBlockDesignation clonedCarBlockDesignation = bedDesignation.clone();
            clonedCarBlockDesignationList.add(clonedCarBlockDesignation);
        }
        clone.carBlockDesignationList = clonedCarBlockDesignationList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof TrainDesign)) {
            return false;
        }
        TrainDesign other = (TrainDesign)o;
        if (this.carBlockDesignationList.size() != other.carBlockDesignationList.size()) {
            return false;
        }
        Iterator<CarBlockDesignation> it = this.carBlockDesignationList.iterator();
        Iterator<CarBlockDesignation> otherIt = other.carBlockDesignationList.iterator();
        while (it.hasNext()) {
            CarBlockDesignation otherCarBlockDesignation;
            CarBlockDesignation bedDesignation = it.next();
            if (bedDesignation.solutionEquals(otherCarBlockDesignation = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (CarBlockDesignation bedDesignation : this.carBlockDesignationList) {
            hashCodeBuilder.append(bedDesignation.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }

    public void initializeTransientProperties() {
        for (RailNode origin : this.railNodeList) {
            origin.initializeShortestPathMap(this.railNodeList);
        }
        for (CrewSegment crewSegment : this.crewSegmentList) {
            crewSegment.initializeShortestPath();
        }
    }
}

