/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.heuristic.selector.entity;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.heuristic.selector.SelectorConfig;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionFilter;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.heuristic.selector.entity.FromSolutionEntitySelector;
import org.drools.planner.core.heuristic.selector.entity.decorator.CachingEntitySelector;
import org.drools.planner.core.heuristic.selector.entity.decorator.FilteringEntitySelector;
import org.drools.planner.core.heuristic.selector.entity.decorator.ProbabilityEntitySelector;
import org.drools.planner.core.heuristic.selector.entity.decorator.ShufflingEntitySelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="entitySelector")
public class EntitySelectorConfig
extends SelectorConfig {
    protected Class<?> planningEntityClass = null;
    protected SelectionCacheType cacheType = null;
    protected SelectionOrder selectionOrder = null;
    @XStreamImplicit(itemFieldName="entityFilterClass")
    protected List<Class<? extends SelectionFilter>> entityFilterClassList = null;
    protected Class<? extends SelectionProbabilityWeightFactory> entityProbabilityWeightFactoryClass = null;

    public Class<?> getPlanningEntityClass() {
        return this.planningEntityClass;
    }

    public void setPlanningEntityClass(Class<?> planningEntityClass) {
        this.planningEntityClass = planningEntityClass;
    }

    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(SelectionCacheType cacheType) {
        this.cacheType = cacheType;
    }

    public SelectionOrder getSelectionOrder() {
        return this.selectionOrder;
    }

    public void setSelectionOrder(SelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public List<Class<? extends SelectionFilter>> getEntityFilterClassList() {
        return this.entityFilterClassList;
    }

    public void setEntityFilterClassList(List<Class<? extends SelectionFilter>> entityFilterClassList) {
        this.entityFilterClassList = entityFilterClassList;
    }

    public Class<? extends SelectionProbabilityWeightFactory> getEntityProbabilityWeightFactoryClass() {
        return this.entityProbabilityWeightFactoryClass;
    }

    public void setEntityProbabilityWeightFactoryClass(Class<? extends SelectionProbabilityWeightFactory> entityProbabilityWeightFactoryClass) {
        this.entityProbabilityWeightFactoryClass = entityProbabilityWeightFactoryClass;
    }

    public EntitySelector buildEntitySelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        PlanningEntityDescriptor entityDescriptor = this.fetchEntityDescriptor(solutionDescriptor);
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(this.cacheType, minimumCacheType);
        minimumCacheType = SelectionCacheType.max(minimumCacheType, resolvedCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(this.selectionOrder, inheritedSelectionOrder);
        EntitySelector entitySelector = this.buildBaseEntitySelector(environmentMode, entityDescriptor, minimumCacheType, resolvedCacheType.isCached() ? SelectionOrder.ORIGINAL : resolvedSelectionOrder);
        boolean alreadyCached = false;
        if (!CollectionUtils.isEmpty(this.entityFilterClassList) || entityDescriptor.hasMovableEntitySelectionFilter()) {
            ArrayList<SelectionFilter> entityFilterList = new ArrayList<SelectionFilter>(this.entityFilterClassList == null ? 1 : this.entityFilterClassList.size());
            if (this.entityFilterClassList != null) {
                for (Class<? extends SelectionFilter> entityFilterClass : this.entityFilterClassList) {
                    entityFilterList.add(ConfigUtils.newInstance(this, "entityFilterClass", entityFilterClass));
                }
            }
            if (entityDescriptor.hasMovableEntitySelectionFilter()) {
                entityFilterList.add(entityDescriptor.getMovableEntitySelectionFilter());
            }
            entitySelector = new FilteringEntitySelector(entitySelector, entityFilterList);
            alreadyCached = false;
        }
        if (this.entityProbabilityWeightFactoryClass != null) {
            if (resolvedSelectionOrder != SelectionOrder.RANDOM) {
                throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") with entityProbabilityWeightFactoryClass (" + this.entityProbabilityWeightFactoryClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.RANDOM) + ".");
            }
            SelectionProbabilityWeightFactory entityProbabilityWeightFactory = ConfigUtils.newInstance(this, "entityProbabilityWeightFactoryClass", this.entityProbabilityWeightFactoryClass);
            entitySelector = new ProbabilityEntitySelector(entitySelector, resolvedCacheType, entityProbabilityWeightFactory);
            alreadyCached = true;
        }
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            entitySelector = new ShufflingEntitySelector(entitySelector, resolvedCacheType);
            alreadyCached = true;
        }
        if (resolvedCacheType.isCached() && !alreadyCached) {
            entitySelector = new CachingEntitySelector(entitySelector, resolvedCacheType, resolvedSelectionOrder == SelectionOrder.RANDOM);
        }
        return entitySelector;
    }

    private PlanningEntityDescriptor fetchEntityDescriptor(SolutionDescriptor solutionDescriptor) {
        PlanningEntityDescriptor entityDescriptor;
        if (this.planningEntityClass != null) {
            entityDescriptor = solutionDescriptor.getPlanningEntityDescriptorStrict(this.planningEntityClass);
            if (entityDescriptor == null) {
                throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") has a planningEntityClass (" + this.planningEntityClass + ") that is not configured as a planningEntity.\n" + "If that class (" + this.planningEntityClass.getSimpleName() + ") is not a " + "planningEntityClass (" + solutionDescriptor.getPlanningEntityClassSet() + "), check your Solution implementation's annotated methods.\n" + "If it is, check your solver configuration.");
            }
        } else {
            Collection<PlanningEntityDescriptor> planningEntityDescriptors = solutionDescriptor.getPlanningEntityDescriptors();
            if (planningEntityDescriptors.size() != 1) {
                throw new IllegalArgumentException("The entitySelectorConfig (" + this + ") has no configured planningEntityClass (" + this.planningEntityClass + ") and because there are multiple in the planningEntityClassSet (" + solutionDescriptor.getPlanningEntityClassSet() + "), it can not be deducted automatically.");
            }
            entityDescriptor = planningEntityDescriptors.iterator().next();
        }
        return entityDescriptor;
    }

    private EntitySelector buildBaseEntitySelector(EnvironmentMode environmentMode, PlanningEntityDescriptor entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder) {
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) < 0) {
            minimumCacheType = SelectionCacheType.STEP;
        }
        if (minimumCacheType == SelectionCacheType.SOLVER) {
            throw new IllegalArgumentException("The minimumCacheType (" + (Object)((Object)minimumCacheType) + ") is not yet supported. Please use " + (Object)((Object)SelectionCacheType.PHASE) + " instead.");
        }
        return new FromSolutionEntitySelector(entityDescriptor, minimumCacheType, resolvedSelectionOrder == SelectionOrder.RANDOM);
    }

    public void inherit(EntitySelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.planningEntityClass = ConfigUtils.inheritOverwritableProperty(this.planningEntityClass, inheritedConfig.getPlanningEntityClass());
        this.cacheType = ConfigUtils.inheritOverwritableProperty(this.cacheType, inheritedConfig.getCacheType());
        this.selectionOrder = ConfigUtils.inheritOverwritableProperty(this.selectionOrder, inheritedConfig.getSelectionOrder());
        this.entityFilterClassList = ConfigUtils.inheritOverwritableProperty(this.entityFilterClassList, inheritedConfig.getEntityFilterClassList());
        this.entityProbabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.entityProbabilityWeightFactoryClass, inheritedConfig.getEntityProbabilityWeightFactoryClass());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.planningEntityClass + ")";
    }
}

