/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.constructionheuristic.placer.entity;

import java.util.Iterator;
import org.drools.planner.core.constructionheuristic.placer.AbstractPlacer;
import org.drools.planner.core.constructionheuristic.placer.entity.EntityPlacer;
import org.drools.planner.core.constructionheuristic.placer.value.ValuePlacer;
import org.drools.planner.core.constructionheuristic.scope.ConstructionHeuristicStepScope;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.score.director.ScoreDirector;

public class QueuedEntityPlacer
extends AbstractPlacer
implements EntityPlacer {
    protected final EntitySelector entitySelector;
    protected final ValuePlacer valuePlacer;
    protected Iterator<Object> entityIterator = null;

    public QueuedEntityPlacer(EntitySelector entitySelector, ValuePlacer valuePlacer) {
        this.entitySelector = entitySelector;
        this.valuePlacer = valuePlacer;
        this.solverPhaseLifecycleSupport.addEventListener(entitySelector);
        this.solverPhaseLifecycleSupport.addEventListener(valuePlacer);
    }

    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        super.phaseStarted(solverPhaseScope);
        this.entityIterator = this.entitySelector.iterator();
    }

    public boolean hasPlacement() {
        return this.entityIterator.hasNext();
    }

    public void doPlacement(ConstructionHeuristicStepScope stepScope) {
        Object entity = this.entityIterator.next();
        stepScope.setEntity(entity);
        ScoreDirector scoreDirector = stepScope.getScoreDirector();
        scoreDirector.beforeEntityAdded(entity);
        scoreDirector.afterEntityAdded(entity);
        this.valuePlacer.doPlacement(stepScope);
    }

    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        super.phaseEnded(solverPhaseScope);
        this.entityIterator = null;
    }
}

