/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.entity;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.entity.PlanningEntityDifficultyWeightFactory;
import org.drools.planner.api.domain.variable.DependentPlanningVariable;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.entity.PlanningEntitySorter;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.DependentPlanningVariableDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionFilter;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningEntityDescriptor {
    private final SolutionDescriptor solutionDescriptor;
    private final Class<?> planningEntityClass;
    private final BeanInfo planningEntityBeanInfo;
    private SelectionFilter movableEntitySelectionFilter;
    private PlanningEntitySorter planningEntitySorter;
    private Map<String, PlanningVariableDescriptor> planningVariableDescriptorMap;
    private Map<String, DependentPlanningVariableDescriptor> dependentPlanningVariableDescriptorMap;

    public PlanningEntityDescriptor(SolutionDescriptor solutionDescriptor, Class<?> planningEntityClass) {
        this.solutionDescriptor = solutionDescriptor;
        this.planningEntityClass = planningEntityClass;
        try {
            this.planningEntityBeanInfo = Introspector.getBeanInfo(planningEntityClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("The planningEntityClass (" + planningEntityClass + ") is not a valid java bean.", e);
        }
    }

    public void processAnnotations() {
        this.processEntityAnnotations();
        this.processPropertyAnnotations();
    }

    private void processEntityAnnotations() {
        PlanningEntity planningEntityAnnotation = this.planningEntityClass.getAnnotation(PlanningEntity.class);
        if (planningEntityAnnotation == null) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") has been specified as a planning entity in the configuration," + " but does not have a PlanningEntity annotation.");
        }
        this.processMovable(planningEntityAnnotation);
        this.planningEntitySorter = new PlanningEntitySorter();
        this.processDifficulty(planningEntityAnnotation);
    }

    private void processMovable(PlanningEntity planningEntityAnnotation) {
        Class<? extends SelectionFilter> movableEntitySelectionFilterClass = planningEntityAnnotation.movableEntitySelectionFilter();
        if (movableEntitySelectionFilterClass == PlanningEntity.NullMovableEntitySelectionFilter.class) {
            movableEntitySelectionFilterClass = null;
        }
        if (movableEntitySelectionFilterClass != null) {
            this.movableEntitySelectionFilter = ConfigUtils.newInstance(this, "movableEntitySelectionFilterClass", movableEntitySelectionFilterClass);
        }
    }

    private void processDifficulty(PlanningEntity planningEntityAnnotation) {
        Class<? extends PlanningEntityDifficultyWeightFactory> difficultyWeightFactoryClass;
        Class<? extends Comparator> difficultyComparatorClass = planningEntityAnnotation.difficultyComparatorClass();
        if (difficultyComparatorClass == PlanningEntity.NullDifficultyComparator.class) {
            difficultyComparatorClass = null;
        }
        if ((difficultyWeightFactoryClass = planningEntityAnnotation.difficultyWeightFactoryClass()) == PlanningEntity.NullDifficultyWeightFactory.class) {
            difficultyWeightFactoryClass = null;
        }
        if (difficultyComparatorClass != null && difficultyWeightFactoryClass != null) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") cannot have a difficultyComparatorClass (" + difficultyComparatorClass.getName() + ") and a difficultyWeightFactoryClass (" + difficultyWeightFactoryClass.getName() + ") at the same time.");
        }
        if (difficultyComparatorClass != null) {
            Comparator difficultyComparator = ConfigUtils.newInstance(this, "difficultyComparatorClass", difficultyComparatorClass);
            this.planningEntitySorter.setDifficultyComparator(difficultyComparator);
        }
        if (difficultyWeightFactoryClass != null) {
            PlanningEntityDifficultyWeightFactory difficultyWeightFactory = ConfigUtils.newInstance(this, "difficultyWeightFactoryClass", difficultyWeightFactoryClass);
            this.planningEntitySorter.setDifficultyWeightFactory(difficultyWeightFactory);
        }
    }

    private void processPropertyAnnotations() {
        Method propertyGetter;
        PropertyDescriptor[] propertyDescriptors = this.planningEntityBeanInfo.getPropertyDescriptors();
        int mapSize = propertyDescriptors.length;
        this.planningVariableDescriptorMap = new LinkedHashMap<String, PlanningVariableDescriptor>(mapSize);
        boolean noPlanningVariableAnnotation = true;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            propertyGetter = propertyDescriptor.getReadMethod();
            if (propertyGetter == null || !propertyGetter.isAnnotationPresent(PlanningVariable.class)) continue;
            if (propertyGetter.isAnnotationPresent(DependentPlanningVariable.class)) {
                throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") has a PlanningVariable annotated property (" + propertyDescriptor.getName() + ") that is also annotated with DependentPlanningVariable.");
            }
            noPlanningVariableAnnotation = false;
            if (propertyDescriptor.getWriteMethod() == null) {
                throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") has a PlanningVariable annotated property (" + propertyDescriptor.getName() + ") that should have a setter.");
            }
            PlanningVariableDescriptor planningVariableDescriptor = new PlanningVariableDescriptor(this, propertyDescriptor);
            this.planningVariableDescriptorMap.put(propertyDescriptor.getName(), planningVariableDescriptor);
            planningVariableDescriptor.processAnnotations();
        }
        this.dependentPlanningVariableDescriptorMap = new LinkedHashMap<String, DependentPlanningVariableDescriptor>(mapSize);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            propertyGetter = propertyDescriptor.getReadMethod();
            if (propertyGetter == null || !propertyGetter.isAnnotationPresent(DependentPlanningVariable.class)) continue;
            if (propertyDescriptor.getWriteMethod() == null) {
                throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") has a DependentPlanningVariable annotated property (" + propertyDescriptor.getName() + ") that should have a setter.");
            }
            DependentPlanningVariableDescriptor dependentPlanningVariableDescriptor = new DependentPlanningVariableDescriptor(this, propertyDescriptor);
            this.dependentPlanningVariableDescriptorMap.put(propertyDescriptor.getName(), dependentPlanningVariableDescriptor);
            dependentPlanningVariableDescriptor.processAnnotations();
        }
        if (noPlanningVariableAnnotation) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityClass + ") should have at least 1 getter with a PlanningVariable annotation.");
        }
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Class<?> getPlanningEntityClass() {
        return this.planningEntityClass;
    }

    public boolean appliesToPlanningEntity(Object entity) {
        return entity.getClass().isAssignableFrom(this.planningEntityClass);
    }

    public PlanningEntitySorter getPlanningEntitySorter() {
        return this.planningEntitySorter;
    }

    public boolean hasMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter != null;
    }

    public SelectionFilter getMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter;
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        for (PropertyDescriptor propertyDescriptor : this.planningEntityBeanInfo.getPropertyDescriptors()) {
            if (!propertyDescriptor.getName().equals(propertyName)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public Collection<String> getPlanningVariableNameSet() {
        return this.planningVariableDescriptorMap.keySet();
    }

    public Collection<PlanningVariableDescriptor> getPlanningVariableDescriptors() {
        return this.planningVariableDescriptorMap.values();
    }

    public PlanningVariableDescriptor getPlanningVariableDescriptor(String propertyName) {
        return this.planningVariableDescriptorMap.get(propertyName);
    }

    public List<Object> extractEntities(Solution solution) {
        return this.solutionDescriptor.getPlanningEntityListByPlanningEntityClass(solution, this.planningEntityClass);
    }

    public long getProblemScale(Solution solution, Object planningEntity) {
        long problemScale = 1L;
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptorMap.values()) {
            problemScale *= planningVariableDescriptor.getProblemScale(solution, planningEntity);
        }
        return problemScale;
    }

    @Deprecated
    public boolean isInitialized(Object planningEntity) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptorMap.values()) {
            if (planningVariableDescriptor.isInitialized(planningEntity)) continue;
            return false;
        }
        return true;
    }

    public void uninitialize(Object planningEntity) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptorMap.values()) {
            planningVariableDescriptor.uninitialize(planningEntity);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.planningEntityClass.getName() + ")";
    }
}

