/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.common;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SelectionCacheType {
    JUST_IN_TIME,
    STEP,
    PHASE,
    SOLVER;


    public static SelectionCacheType resolve(SelectionCacheType cacheType, SelectionCacheType minimumCacheType) {
        if (cacheType == null) {
            return JUST_IN_TIME;
        }
        if (cacheType != JUST_IN_TIME && cacheType.compareTo(minimumCacheType) < 0) {
            throw new IllegalArgumentException("The cacheType (" + (Object)((Object)cacheType) + ") is wasteful because an ancestor has a higher cacheType (" + (Object)((Object)minimumCacheType) + ").");
        }
        return cacheType;
    }

    public boolean isCached() {
        switch (this) {
            case JUST_IN_TIME: {
                return false;
            }
            case STEP: 
            case PHASE: 
            case SOLVER: {
                return true;
            }
        }
        throw new IllegalStateException("The cacheType (" + (Object)((Object)this) + ") is not implemented");
    }

    public boolean isNotCached() {
        return !this.isCached();
    }

    public static SelectionCacheType max(SelectionCacheType a, SelectionCacheType b) {
        if (a.compareTo(b) >= 0) {
            return a;
        }
        return b;
    }
}

