/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.generic.chained;

import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.move.generic.SwapMove;
import org.drools.planner.core.heuristic.selector.move.generic.chained.ChainedMoveUtils;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedSwapMove
extends SwapMove {
    public ChainedSwapMove(Collection<PlanningVariableDescriptor> variableDescriptors, Object leftEntity, Object rightEntity) {
        super(variableDescriptors, leftEntity, rightEntity);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new ChainedSwapMove(this.variableDescriptors, this.rightEntity, this.leftEntity);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (PlanningVariableDescriptor variableDescriptor : this.variableDescriptors) {
            Object oldRightValue;
            Object oldLeftValue = variableDescriptor.getValue(this.leftEntity);
            if (ObjectUtils.equals((Object)oldLeftValue, (Object)(oldRightValue = variableDescriptor.getValue(this.rightEntity)))) continue;
            if (!variableDescriptor.isChained()) {
                scoreDirector.beforeVariableChanged(this.leftEntity, variableDescriptor.getVariableName());
                variableDescriptor.setValue(this.leftEntity, oldRightValue);
                scoreDirector.afterVariableChanged(this.leftEntity, variableDescriptor.getVariableName());
                scoreDirector.beforeVariableChanged(this.rightEntity, variableDescriptor.getVariableName());
                variableDescriptor.setValue(this.rightEntity, oldLeftValue);
                scoreDirector.afterVariableChanged(this.rightEntity, variableDescriptor.getVariableName());
                continue;
            }
            if (oldRightValue != this.leftEntity) {
                ChainedMoveUtils.doChainedChange(scoreDirector, this.leftEntity, variableDescriptor, oldRightValue);
            }
            if (oldLeftValue == this.rightEntity) continue;
            ChainedMoveUtils.doChainedChange(scoreDirector, this.rightEntity, variableDescriptor, oldLeftValue);
        }
    }
}

