/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.phase;

import java.util.List;
import java.util.Random;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSolverPhaseScope {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected DefaultSolverScope solverScope;
    protected long startingSystemTimeMillis;
    protected Score startingScore;
    protected int bestSolutionStepIndex;

    public AbstractSolverPhaseScope(DefaultSolverScope solverScope) {
        this.solverScope = solverScope;
    }

    public DefaultSolverScope getSolverScope() {
        return this.solverScope;
    }

    public long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public Score getStartingScore() {
        return this.startingScore;
    }

    public void setStartingScore(Score startingScore) {
        this.startingScore = startingScore;
    }

    public int getBestSolutionStepIndex() {
        return this.bestSolutionStepIndex;
    }

    public void setBestSolutionStepIndex(int bestSolutionStepIndex) {
        this.bestSolutionStepIndex = bestSolutionStepIndex;
    }

    public abstract AbstractStepScope getLastCompletedStepScope();

    public void reset() {
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.bestSolutionStepIndex = -1;
        this.startingScore = this.solverScope.calculateScore();
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solverScope.getSolutionDescriptor();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.solverScope.getScoreDefinition();
    }

    public long calculateSolverTimeMillisSpend() {
        return this.solverScope.calculateTimeMillisSpend();
    }

    public long calculatePhaseTimeMillisSpend() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    public ScoreDirector getScoreDirector() {
        return this.solverScope.getScoreDirector();
    }

    public Solution getWorkingSolution() {
        return this.solverScope.getWorkingSolution();
    }

    public List<Object> getWorkingPlanningEntityList() {
        return this.solverScope.getWorkingPlanningEntityList();
    }

    public boolean isWorkingSolutionInitialized() {
        return this.solverScope.isWorkingSolutionInitialized();
    }

    public Score calculateScore() {
        return this.solverScope.calculateScore();
    }

    public void assertWorkingScore(Score workingScore) {
        this.solverScope.assertWorkingScore(workingScore);
    }

    public Random getWorkingRandom() {
        return this.solverScope.getWorkingRandom();
    }

    public Score getBestScore() {
        return this.solverScope.getBestScore();
    }

    public void assertUndoMoveIsUncorrupted(Move move, Move undoMove) {
        Score lastCompletedStepScore;
        Score undoScore = this.calculateScore();
        if (!undoScore.equals(lastCompletedStepScore = this.getLastCompletedStepScope().getScore())) {
            this.getScoreDirector().assertWorkingScore(undoScore);
            throw new IllegalStateException("The moveClass (" + move.getClass() + ")'s move (" + move + ") probably has a corrupted undoMove (" + undoMove + ")." + " Or maybe there are corrupted score rules.\n" + "Check the Move.createUndoMove(...) method of that Move class" + " and enable EnvironmentMode TRACE to fail-faster on corrupted score rules.\n" + "Score corruption: the lastCompletedStepScore (" + lastCompletedStepScore + ") is not the undoScore (" + undoScore + ").");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

