/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.phase.custom;

import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.phase.custom.CustomSolverPhase;
import org.drools.planner.core.phase.custom.CustomSolverPhaseCommand;
import org.drools.planner.core.phase.custom.scope.CustomSolverPhaseScope;
import org.drools.planner.core.phase.custom.scope.CustomStepScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCustomSolverPhase
extends AbstractSolverPhase
implements CustomSolverPhase {
    protected List<CustomSolverPhaseCommand> customSolverPhaseCommandList;
    protected boolean forceUpdateBestSolution;

    public void setCustomSolverPhaseCommandList(List<CustomSolverPhaseCommand> customSolverPhaseCommandList) {
        this.customSolverPhaseCommandList = customSolverPhaseCommandList;
    }

    public void setForceUpdateBestSolution(boolean forceUpdateBestSolution) {
        this.forceUpdateBestSolution = forceUpdateBestSolution;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        CustomSolverPhaseScope customSolverPhaseScope = new CustomSolverPhaseScope(solverScope);
        this.phaseStarted(customSolverPhaseScope);
        CustomStepScope stepScope = this.createNextStepScope(customSolverPhaseScope, null);
        Iterator<CustomSolverPhaseCommand> commandIterator = this.customSolverPhaseCommandList.iterator();
        while (!this.termination.isPhaseTerminated(customSolverPhaseScope) && commandIterator.hasNext()) {
            CustomSolverPhaseCommand customSolverPhaseCommand = commandIterator.next();
            this.stepStarted(stepScope);
            customSolverPhaseCommand.changeWorkingSolution(solverScope.getScoreDirector());
            Score score = customSolverPhaseScope.calculateScore();
            stepScope.setScore(score);
            this.stepEnded(stepScope);
            stepScope = this.createNextStepScope(customSolverPhaseScope, stepScope);
        }
        this.phaseEnded(customSolverPhaseScope);
    }

    private CustomStepScope createNextStepScope(CustomSolverPhaseScope phaseScope, CustomStepScope completedStepScope) {
        if (completedStepScope == null) {
            completedStepScope = new CustomStepScope(phaseScope);
            completedStepScope.setScore(phaseScope.getStartingScore());
            completedStepScope.setStepIndex(-1);
        }
        phaseScope.setLastCompletedStepScope(completedStepScope);
        CustomStepScope stepScope = new CustomStepScope(phaseScope);
        stepScope.setStepIndex(completedStepScope.getStepIndex() + 1);
        stepScope.setSolutionInitialized(true);
        return stepScope;
    }

    public void phaseStarted(CustomSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
    }

    public void stepStarted(CustomStepScope stepScope) {
        super.stepStarted(stepScope);
    }

    public void stepEnded(CustomStepScope stepScope) {
        super.stepEnded(stepScope);
        boolean bestScoreImproved = stepScope.getBestScoreImproved();
        if (this.forceUpdateBestSolution && !bestScoreImproved) {
            this.bestSolutionRecaller.updateBestSolution(stepScope.getPhaseScope().getSolverScope(), stepScope.createOrGetClonedSolution());
        }
        CustomSolverPhaseScope customSolverPhaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = customSolverPhaseScope.calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}), {} best score ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpend, stepScope.getScore(), bestScoreImproved ? "new" : (this.forceUpdateBestSolution ? "forced" : "   "), customSolverPhaseScope.getBestScore()});
        }
    }

    public void phaseEnded(CustomSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.logger.info("Phase custom ended: step total ({}), time spend ({}), best score ({}).", new Object[]{phaseScope.getLastCompletedStepScope().getStepIndex() + 1, phaseScope.calculateSolverTimeMillisSpend(), phaseScope.getBestScore()});
    }
}

