/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.termination;

import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.termination.AbstractTermination;

public class UnimprovedStepCountTermination
extends AbstractTermination {
    private int maximumUnimprovedStepCount = 100;

    public void setMaximumUnimprovedStepCount(int maximumUnimprovedStepCount) {
        this.maximumUnimprovedStepCount = maximumUnimprovedStepCount;
        if (maximumUnimprovedStepCount < 0) {
            throw new IllegalArgumentException("Property maximumUnimprovedStepCount (" + maximumUnimprovedStepCount + ") must be greater or equal to 0.");
        }
    }

    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException("StepCountTermination can only be used for phase termination.");
    }

    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(phaseScope);
        return unimprovedStepCount >= this.maximumUnimprovedStepCount;
    }

    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException("StepCountTermination can only be used for phase termination.");
    }

    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(phaseScope);
        double timeGradient = (double)unimprovedStepCount / (double)this.maximumUnimprovedStepCount;
        return Math.min(timeGradient, 1.0);
    }

    private int calculateUnimprovedStepCount(AbstractSolverPhaseScope phaseScope) {
        int bestStepIndex = phaseScope.getBestSolutionStepIndex();
        int lastStepIndex = phaseScope.getLastCompletedStepScope().getStepIndex();
        return lastStepIndex - bestStepIndex;
    }
}

