/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.solver.score;

import org.drools.planner.core.score.buildin.hardandsoft.DefaultHardAndSoftScore;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScore;
import org.drools.planner.core.score.director.simple.SimpleScoreCalculator;
import org.drools.planner.examples.cloudbalancing.domain.CloudBalance;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudBalancingSimpleScoreCalculator
implements SimpleScoreCalculator<CloudBalance> {
    public HardAndSoftScore calculateScore(CloudBalance cloudBalance) {
        int hardScore = 0;
        int softScore = 0;
        for (CloudComputer computer : cloudBalance.getComputerList()) {
            int networkBandwidthAvailable;
            int memoryAvailable;
            int cpuPowerUsage = 0;
            int memoryUsage = 0;
            int networkBandwidthUsage = 0;
            boolean used = false;
            for (CloudProcess process : cloudBalance.getProcessList()) {
                if (!computer.equals(process.getComputer())) continue;
                cpuPowerUsage += process.getRequiredCpuPower();
                memoryUsage += process.getRequiredMemory();
                networkBandwidthUsage += process.getRequiredNetworkBandwidth();
                used = true;
            }
            int cpuPowerAvailable = computer.getCpuPower() - cpuPowerUsage;
            if (cpuPowerAvailable < 0) {
                hardScore += cpuPowerAvailable;
            }
            if ((memoryAvailable = computer.getMemory() - memoryUsage) < 0) {
                hardScore += memoryAvailable;
            }
            if ((networkBandwidthAvailable = computer.getNetworkBandwidth() - networkBandwidthUsage) < 0) {
                hardScore += networkBandwidthAvailable;
            }
            if (!used) continue;
            softScore -= computer.getCost();
        }
        return DefaultHardAndSoftScore.valueOf(hardScore, softScore);
    }
}

