/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.persistence;

import java.io.File;
import java.util.Arrays;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.app.LoggingMain;
import org.drools.planner.examples.common.persistence.SolutionDao;

public abstract class AbstractSolutionImporter
extends LoggingMain {
    protected static final String DEFAULT_OUTPUT_FILE_SUFFIX = ".xml";
    protected SolutionDao solutionDao;

    public AbstractSolutionImporter(SolutionDao solutionDao) {
        this.solutionDao = solutionDao;
    }

    protected File getInputDir() {
        return new File(this.solutionDao.getDataDir(), "input");
    }

    public abstract String getInputFileSuffix();

    protected File getOutputDir() {
        return new File(this.solutionDao.getDataDir(), "unsolved");
    }

    protected String getOutputFileSuffix() {
        return DEFAULT_OUTPUT_FILE_SUFFIX;
    }

    public void convertAll() {
        File inputDir = this.getInputDir();
        File outputDir = this.getOutputDir();
        Object[] inputFiles = inputDir.listFiles();
        if (inputFiles == null) {
            throw new IllegalArgumentException("Your working dir should be drools-planner-examples and contain: " + inputDir);
        }
        Arrays.sort(inputFiles);
        for (Object inputFile : inputFiles) {
            if (!this.acceptInputFile((File)inputFile)) continue;
            Solution solution = this.readSolution((File)inputFile);
            String inputFileName = ((File)inputFile).getName();
            String outputFileName = inputFileName.substring(0, inputFileName.length() - this.getInputFileSuffix().length()) + this.getOutputFileSuffix();
            File outputFile = new File(outputDir, outputFileName);
            this.solutionDao.writeSolution(solution, outputFile);
        }
    }

    public boolean acceptInputFile(File inputFile) {
        return inputFile.getName().endsWith(this.getInputFileSuffix());
    }

    public abstract Solution readSolution(File var1);
}

