/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.solver.score;

import java.util.List;
import org.drools.planner.core.score.buildin.simple.DefaultSimpleScore;
import org.drools.planner.core.score.buildin.simple.SimpleScore;
import org.drools.planner.core.score.director.simple.SimpleScoreCalculator;
import org.drools.planner.examples.nqueens.domain.NQueens;
import org.drools.planner.examples.nqueens.domain.Queen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NQueensSimpleScoreCalculator
implements SimpleScoreCalculator<NQueens> {
    public SimpleScore calculateScore(NQueens nQueens) {
        int n = nQueens.getN();
        List<Queen> queenList = nQueens.getQueenList();
        int score = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                Queen leftQueen = queenList.get(i);
                Queen rightQueen = queenList.get(j);
                if (leftQueen.getRow() == null || rightQueen.getRow() == null) continue;
                if (leftQueen.getRowIndex() == rightQueen.getRowIndex()) {
                    --score;
                }
                if (leftQueen.getAscendingDiagonalIndex() == rightQueen.getAscendingDiagonalIndex()) {
                    --score;
                }
                if (leftQueen.getDescendingDiagonalIndex() != rightQueen.getDescendingDiagonalIndex()) continue;
                --score;
            }
        }
        return DefaultSimpleScore.valueOf(score);
    }
}

