/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.solver.move.factory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.drools.planner.core.heuristic.selector.move.factory.MoveListFactory;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.nurserostering.domain.NurseRoster;
import org.drools.planner.examples.nurserostering.domain.ShiftAssignment;
import org.drools.planner.examples.nurserostering.domain.solver.MovableShiftAssignmentSelectionFilter;
import org.drools.planner.examples.nurserostering.solver.move.ShiftAssignmentSwapMove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiftAssignmentSwapMoveFactory
implements MoveListFactory {
    private MovableShiftAssignmentSelectionFilter filter = new MovableShiftAssignmentSelectionFilter();

    @Override
    public List<Move> createMoveList(Solution solution) {
        NurseRoster nurseRoster = (NurseRoster)solution;
        ArrayList<ShiftAssignment> shiftAssignmentList = new ArrayList<ShiftAssignment>(nurseRoster.getShiftAssignmentList());
        Iterator it = shiftAssignmentList.iterator();
        while (it.hasNext()) {
            ShiftAssignment shiftAssignment = (ShiftAssignment)it.next();
            if (this.filter.accept(nurseRoster, shiftAssignment)) continue;
            it.remove();
        }
        ArrayList<Move> moveList = new ArrayList<Move>();
        ListIterator leftIt = shiftAssignmentList.listIterator();
        while (leftIt.hasNext()) {
            ShiftAssignment leftShiftAssignment = (ShiftAssignment)leftIt.next();
            ListIterator rightIt = shiftAssignmentList.listIterator(leftIt.nextIndex());
            while (rightIt.hasNext()) {
                ShiftAssignment rightShiftAssignment = (ShiftAssignment)rightIt.next();
                moveList.add(new ShiftAssignmentSwapMove(leftShiftAssignment, rightShiftAssignment));
            }
        }
        return moveList;
    }
}

