/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.config;

import com.thoughtworks.xstream.XStream;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.drools.planner.benchmark.api.PlannerBenchmark;
import org.drools.planner.benchmark.config.PlannerBenchmarkConfig;
import org.drools.planner.config.XmlSolverFactory;

public class XmlPlannerBenchmarkFactory {
    private XStream xStream = XmlSolverFactory.buildXstream();
    private PlannerBenchmarkConfig plannerBenchmarkConfig = null;

    public XmlPlannerBenchmarkFactory() {
        this.xStream.processAnnotations(PlannerBenchmarkConfig.class);
    }

    public void addXstreamAnnotations(Class ... xstreamAnnotations) {
        this.xStream.processAnnotations(xstreamAnnotations);
    }

    public XmlPlannerBenchmarkFactory configure(String resource) {
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException("Could not find resource (" + resource + ").");
        }
        return this.configure(in);
    }

    public XmlPlannerBenchmarkFactory configure(InputStream in) {
        XmlPlannerBenchmarkFactory xmlPlannerBenchmarkFactory;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, "UTF-8");
            xmlPlannerBenchmarkFactory = this.configure(reader);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)in);
        return xmlPlannerBenchmarkFactory;
    }

    public XmlPlannerBenchmarkFactory configure(Reader reader) {
        this.plannerBenchmarkConfig = (PlannerBenchmarkConfig)this.xStream.fromXML(reader);
        return this;
    }

    public XmlPlannerBenchmarkFactory configureFromTemplate(String templateResource) {
        return this.configureFromTemplate(templateResource, null);
    }

    public XmlPlannerBenchmarkFactory configureFromTemplate(String templateResource, Object model) {
        InputStream templateIn = this.getClass().getResourceAsStream(templateResource);
        if (templateIn == null) {
            throw new IllegalArgumentException("Could not find templateResource (" + templateResource + ").");
        }
        return this.configureFromTemplate(templateIn, null);
    }

    public XmlPlannerBenchmarkFactory configureFromTemplate(InputStream templateIn) {
        return this.configureFromTemplate(templateIn, null);
    }

    public XmlPlannerBenchmarkFactory configureFromTemplate(InputStream templateIn, Object model) {
        XmlPlannerBenchmarkFactory xmlPlannerBenchmarkFactory;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(templateIn, "UTF-8");
            xmlPlannerBenchmarkFactory = this.configureFromTemplate(reader, model);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)templateIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)templateIn);
        return xmlPlannerBenchmarkFactory;
    }

    public XmlPlannerBenchmarkFactory configureFromTemplate(Reader templateReader) {
        return this.configureFromTemplate(templateReader, null);
    }

    public XmlPlannerBenchmarkFactory configureFromTemplate(Reader templateReader, Object model) {
        Template template;
        Configuration freemarkerCfg = new Configuration();
        freemarkerCfg.setDefaultEncoding("UTF-8");
        freemarkerCfg.setNumberFormat("computer");
        freemarkerCfg.setDateFormat("yyyy-mm-dd");
        freemarkerCfg.setDateTimeFormat("yyyy-mm-dd HH:mm:ss.SSS z");
        freemarkerCfg.setTimeFormat("HH:mm:ss.SSS");
        String templateFilename = "benchmarkTemplate.ftl";
        try {
            template = new Template(templateFilename, templateReader, freemarkerCfg, "UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not read template (" + templateFilename + ") from templateReader.", e);
        }
        return this.configureFromTemplate(template, model);
    }

    public XmlPlannerBenchmarkFactory configureFromTemplate(Template template) {
        return this.configureFromTemplate(template, null);
    }

    public XmlPlannerBenchmarkFactory configureFromTemplate(Template template, Object model) {
        StringWriter configWriter = new StringWriter();
        try {
            template.process(model, (Writer)configWriter);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not write to configWriter.", e);
        }
        catch (TemplateException e) {
            throw new IllegalArgumentException("Can not process Freemarker template to configWriter.", e);
        }
        finally {
            IOUtils.closeQuietly((Writer)configWriter);
        }
        StringReader configReader = new StringReader(configWriter.toString());
        return this.configure(configReader);
    }

    public PlannerBenchmarkConfig getPlannerBenchmarkConfig() {
        if (this.plannerBenchmarkConfig == null) {
            throw new IllegalStateException("The plannerBenchmarkConfig (" + this.plannerBenchmarkConfig + ") is null," + " call configure(...) first.");
        }
        return this.plannerBenchmarkConfig;
    }

    public PlannerBenchmark buildPlannerBenchmark() {
        if (this.plannerBenchmarkConfig == null) {
            throw new IllegalStateException("The plannerBenchmarkConfig (" + this.plannerBenchmarkConfig + ") is null," + " call configure(...) first.");
        }
        return this.plannerBenchmarkConfig.buildPlannerBenchmark();
    }
}

