/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.heuristic.selector.entity.pillar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Collection;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.heuristic.selector.SelectorConfig;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.heuristic.selector.entity.EntitySelectorConfig;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.heuristic.selector.entity.pillar.PillarSelector;
import org.drools.planner.core.heuristic.selector.entity.pillar.SameValuePillarSelector;

@XStreamAlias(value="pillarSelector")
public class PillarSelectorConfig
extends SelectorConfig {
    @XStreamAlias(value="entitySelector")
    protected EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public PillarSelector buildPillarSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
            throw new IllegalArgumentException("The pillarSelectorConfig (" + this + ")'s minimumCacheType (" + (Object)((Object)minimumCacheType) + ") must not be higher than " + (Object)((Object)SelectionCacheType.STEP) + " because the pillars change every step.");
        }
        EntitySelector entitySelector = this.entitySelectorConfig.buildEntitySelector(environmentMode, solutionDescriptor, minimumCacheType, SelectionOrder.ORIGINAL);
        Collection<PlanningVariableDescriptor> variableDescriptors = entitySelector.getEntityDescriptor().getPlanningVariableDescriptors();
        return new SameValuePillarSelector(entitySelector, variableDescriptors, inheritedSelectionOrder == SelectionOrder.RANDOM);
    }

    public void inherit(PillarSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.entitySelectorConfig == null) {
            this.entitySelectorConfig = inheritedConfig.getEntitySelectorConfig();
        } else if (inheritedConfig.getEntitySelectorConfig() != null) {
            this.entitySelectorConfig.inherit(inheritedConfig.getEntitySelectorConfig());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + ")";
    }
}

