/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.heuristic.selector.move;

import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.heuristic.selector.SelectorConfig;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import org.drools.planner.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.drools.planner.config.heuristic.selector.move.factory.MoveIteratorFactoryConfig;
import org.drools.planner.config.heuristic.selector.move.factory.MoveListFactoryConfig;
import org.drools.planner.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.drools.planner.config.heuristic.selector.move.generic.PillarSwapMoveSelectorConfig;
import org.drools.planner.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import org.drools.planner.config.heuristic.selector.move.generic.chained.SubChainChangeMoveSelectorConfig;
import org.drools.planner.config.heuristic.selector.move.generic.chained.SubChainSwapMoveSelectorConfig;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionFilter;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.heuristic.selector.move.decorator.CachingMoveSelector;
import org.drools.planner.core.heuristic.selector.move.decorator.FilteringMoveSelector;
import org.drools.planner.core.heuristic.selector.move.decorator.ProbabilityMoveSelector;
import org.drools.planner.core.heuristic.selector.move.decorator.ShufflingMoveSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamInclude(value={UnionMoveSelectorConfig.class, CartesianProductMoveSelectorConfig.class, ChangeMoveSelectorConfig.class, SwapMoveSelectorConfig.class, PillarSwapMoveSelectorConfig.class, SubChainChangeMoveSelectorConfig.class, SubChainSwapMoveSelectorConfig.class, MoveListFactoryConfig.class, MoveIteratorFactoryConfig.class})
public abstract class MoveSelectorConfig
extends SelectorConfig {
    protected SelectionCacheType cacheType = null;
    protected SelectionOrder selectionOrder = null;
    @XStreamImplicit(itemFieldName="moveFilterClass")
    protected List<Class<? extends SelectionFilter>> moveFilterClassList = null;
    protected Class<? extends SelectionProbabilityWeightFactory> moveProbabilityWeightFactoryClass = null;
    private Double fixedProbabilityWeight = null;

    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(SelectionCacheType cacheType) {
        this.cacheType = cacheType;
    }

    public SelectionOrder getSelectionOrder() {
        return this.selectionOrder;
    }

    public void setSelectionOrder(SelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public List<Class<? extends SelectionFilter>> getMoveFilterClassList() {
        return this.moveFilterClassList;
    }

    public void setMoveFilterClassList(List<Class<? extends SelectionFilter>> moveFilterClassList) {
        this.moveFilterClassList = moveFilterClassList;
    }

    public Class<? extends SelectionProbabilityWeightFactory> getMoveProbabilityWeightFactoryClass() {
        return this.moveProbabilityWeightFactoryClass;
    }

    public void setMoveProbabilityWeightFactoryClass(Class<? extends SelectionProbabilityWeightFactory> moveProbabilityWeightFactoryClass) {
        this.moveProbabilityWeightFactoryClass = moveProbabilityWeightFactoryClass;
    }

    public Double getFixedProbabilityWeight() {
        return this.fixedProbabilityWeight;
    }

    public void setFixedProbabilityWeight(Double fixedProbabilityWeight) {
        this.fixedProbabilityWeight = fixedProbabilityWeight;
    }

    public MoveSelector buildMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(this.cacheType, minimumCacheType);
        minimumCacheType = SelectionCacheType.max(minimumCacheType, resolvedCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(this.selectionOrder, inheritedSelectionOrder);
        MoveSelector moveSelector = this.buildBaseMoveSelector(environmentMode, solutionDescriptor, minimumCacheType, resolvedCacheType.isCached() ? SelectionOrder.ORIGINAL : resolvedSelectionOrder);
        boolean alreadyCached = false;
        if (!CollectionUtils.isEmpty(this.moveFilterClassList)) {
            ArrayList<SelectionFilter> moveFilterList = new ArrayList<SelectionFilter>(this.moveFilterClassList.size());
            for (Class<? extends SelectionFilter> moveFilterClass : this.moveFilterClassList) {
                moveFilterList.add(ConfigUtils.newInstance(this, "moveFilterClass", moveFilterClass));
            }
            moveSelector = new FilteringMoveSelector(moveSelector, moveFilterList);
            alreadyCached = false;
        }
        if (this.moveProbabilityWeightFactoryClass != null) {
            if (resolvedSelectionOrder != SelectionOrder.RANDOM) {
                throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") with moveProbabilityWeightFactoryClass (" + this.moveProbabilityWeightFactoryClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.RANDOM) + ".");
            }
            SelectionProbabilityWeightFactory entityProbabilityWeightFactory = ConfigUtils.newInstance(this, "moveProbabilityWeightFactoryClass", this.moveProbabilityWeightFactoryClass);
            moveSelector = new ProbabilityMoveSelector(moveSelector, resolvedCacheType, entityProbabilityWeightFactory);
            alreadyCached = true;
        }
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            if (resolvedCacheType.isNotCached()) {
                throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") with resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") has a resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") that is not cached.");
            }
            moveSelector = new ShufflingMoveSelector(moveSelector, resolvedCacheType);
            alreadyCached = true;
        }
        if (resolvedCacheType.isCached() && !alreadyCached) {
            moveSelector = new CachingMoveSelector(moveSelector, resolvedCacheType, resolvedSelectionOrder == SelectionOrder.RANDOM);
        }
        return moveSelector;
    }

    protected abstract MoveSelector buildBaseMoveSelector(EnvironmentMode var1, SolutionDescriptor var2, SelectionCacheType var3, SelectionOrder var4);

    protected void inherit(MoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.cacheType = ConfigUtils.inheritOverwritableProperty(this.cacheType, inheritedConfig.getCacheType());
        this.selectionOrder = ConfigUtils.inheritOverwritableProperty(this.selectionOrder, inheritedConfig.getSelectionOrder());
        this.moveFilterClassList = ConfigUtils.inheritOverwritableProperty(this.moveFilterClassList, inheritedConfig.getMoveFilterClassList());
        this.moveProbabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.moveProbabilityWeightFactoryClass, inheritedConfig.getMoveProbabilityWeightFactoryClass());
        this.fixedProbabilityWeight = ConfigUtils.inheritOverwritableProperty(this.fixedProbabilityWeight, inheritedConfig.getFixedProbabilityWeight());
    }
}

