/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.heuristic.selector.value;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Collection;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.heuristic.selector.SelectorConfig;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.drools.planner.core.heuristic.selector.value.FromSolutionPropertyValueSelector;
import org.drools.planner.core.heuristic.selector.value.ValueSelector;
import org.drools.planner.core.heuristic.selector.value.decorator.CachingValueSelector;
import org.drools.planner.core.heuristic.selector.value.decorator.ProbabilityValueSelector;
import org.drools.planner.core.heuristic.selector.value.decorator.ShufflingValueSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="valueSelector")
public class ValueSelectorConfig
extends SelectorConfig {
    protected String planningVariableName = null;
    protected SelectionCacheType cacheType = null;
    protected SelectionOrder selectionOrder = null;
    protected Class<? extends SelectionProbabilityWeightFactory> valueProbabilityWeightFactoryClass = null;

    public String getPlanningVariableName() {
        return this.planningVariableName;
    }

    public void setPlanningVariableName(String planningVariableName) {
        this.planningVariableName = planningVariableName;
    }

    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(SelectionCacheType cacheType) {
        this.cacheType = cacheType;
    }

    public SelectionOrder getSelectionOrder() {
        return this.selectionOrder;
    }

    public void setSelectionOrder(SelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public Class<? extends SelectionProbabilityWeightFactory> getValueProbabilityWeightFactoryClass() {
        return this.valueProbabilityWeightFactoryClass;
    }

    public void setValueProbabilityWeightFactoryClass(Class<? extends SelectionProbabilityWeightFactory> valueProbabilityWeightFactoryClass) {
        this.valueProbabilityWeightFactoryClass = valueProbabilityWeightFactoryClass;
    }

    public ValueSelector buildValueSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, PlanningEntityDescriptor entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        PlanningVariableDescriptor variableDescriptor = this.fetchVariableDescriptor(entityDescriptor);
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(this.cacheType, minimumCacheType);
        minimumCacheType = SelectionCacheType.max(minimumCacheType, resolvedCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(this.selectionOrder, inheritedSelectionOrder);
        ValueSelector valueSelector = this.buildBaseValueSelector(environmentMode, variableDescriptor, minimumCacheType, resolvedCacheType.isCached() ? SelectionOrder.ORIGINAL : resolvedSelectionOrder);
        boolean alreadyCached = false;
        if (this.valueProbabilityWeightFactoryClass != null) {
            if (resolvedSelectionOrder != SelectionOrder.RANDOM) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with valueProbabilityWeightFactoryClass (" + this.valueProbabilityWeightFactoryClass + ") has a non-random resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ").");
            }
            SelectionProbabilityWeightFactory valueProbabilityWeightFactory = ConfigUtils.newInstance(this, "valueProbabilityWeightFactoryClass", this.valueProbabilityWeightFactoryClass);
            valueSelector = new ProbabilityValueSelector(valueSelector, resolvedCacheType, valueProbabilityWeightFactory);
            alreadyCached = true;
        }
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            valueSelector = new ShufflingValueSelector(valueSelector, resolvedCacheType);
            alreadyCached = true;
        }
        if (resolvedCacheType.isCached() && !alreadyCached) {
            valueSelector = new CachingValueSelector(valueSelector, resolvedCacheType, resolvedSelectionOrder == SelectionOrder.RANDOM);
        }
        return valueSelector;
    }

    private PlanningVariableDescriptor fetchVariableDescriptor(PlanningEntityDescriptor entityDescriptor) {
        PlanningVariableDescriptor variableDescriptor;
        if (this.planningVariableName != null) {
            variableDescriptor = entityDescriptor.getPlanningVariableDescriptor(this.planningVariableName);
            if (variableDescriptor == null) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has a planningVariableName (" + this.planningVariableName + ") for planningEntityClass (" + entityDescriptor.getPlanningEntityClass() + ") that is not annotated as a planningVariable.\n" + "Check your planningEntity implementation's annotated methods.");
            }
        } else {
            Collection<PlanningVariableDescriptor> planningVariableDescriptors = entityDescriptor.getPlanningVariableDescriptors();
            if (planningVariableDescriptors.size() != 1) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has no configured planningVariableName (" + this.planningVariableName + ") for planningEntityClass (" + entityDescriptor.getPlanningEntityClass() + ") and because there are multiple in the planningVariableNameSet (" + entityDescriptor.getPlanningVariableNameSet() + "), it can not be deducted automatically.");
            }
            variableDescriptor = planningVariableDescriptors.iterator().next();
        }
        return variableDescriptor;
    }

    private ValueSelector buildBaseValueSelector(EnvironmentMode environmentMode, PlanningVariableDescriptor variableDescriptor, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder) {
        if (minimumCacheType.compareTo(SelectionCacheType.PHASE) < 0) {
            minimumCacheType = SelectionCacheType.PHASE;
        }
        return new FromSolutionPropertyValueSelector(variableDescriptor, minimumCacheType, resolvedSelectionOrder == SelectionOrder.RANDOM);
    }

    public void inherit(ValueSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.planningVariableName == null) {
            this.planningVariableName = inheritedConfig.getPlanningVariableName();
        }
        this.cacheType = ConfigUtils.inheritOverwritableProperty(this.cacheType, inheritedConfig.getCacheType());
        this.selectionOrder = ConfigUtils.inheritOverwritableProperty(this.selectionOrder, inheritedConfig.getSelectionOrder());
        this.valueProbabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.valueProbabilityWeightFactoryClass, inheritedConfig.getValueProbabilityWeightFactoryClass());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.planningVariableName + ")";
    }
}

