/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.common;

import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class SelectionCacheLifecycleBridge
implements SolverPhaseLifecycleListener {
    protected final SelectionCacheType cacheType;
    protected final SelectionCacheLifecycleListener selectionCacheLifecycleListener;

    public SelectionCacheLifecycleBridge(SelectionCacheType cacheType, SelectionCacheLifecycleListener selectionCacheLifecycleListener) {
        this.cacheType = cacheType;
        this.selectionCacheLifecycleListener = selectionCacheLifecycleListener;
        if (cacheType == null) {
            throw new IllegalArgumentException("The cacheType (" + (Object)((Object)cacheType) + ") for selectionCacheLifecycleListener (" + selectionCacheLifecycleListener + ") should have already been resolved.");
        }
    }

    public void solvingStarted(DefaultSolverScope solverScope) {
        if (this.cacheType == SelectionCacheType.SOLVER) {
            this.selectionCacheLifecycleListener.constructCache(solverScope);
        }
    }

    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        if (this.cacheType == SelectionCacheType.PHASE) {
            this.selectionCacheLifecycleListener.constructCache(phaseScope.getSolverScope());
        }
    }

    public void stepStarted(AbstractStepScope stepScope) {
        if (this.cacheType == SelectionCacheType.STEP) {
            this.selectionCacheLifecycleListener.constructCache(stepScope.getPhaseScope().getSolverScope());
        }
    }

    public void stepEnded(AbstractStepScope stepScope) {
        if (this.cacheType == SelectionCacheType.STEP) {
            this.selectionCacheLifecycleListener.disposeCache(stepScope.getPhaseScope().getSolverScope());
        }
    }

    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        if (this.cacheType == SelectionCacheType.PHASE) {
            this.selectionCacheLifecycleListener.disposeCache(phaseScope.getSolverScope());
        }
    }

    public void solvingEnded(DefaultSolverScope solverScope) {
        if (this.cacheType == SelectionCacheType.SOLVER) {
            this.selectionCacheLifecycleListener.disposeCache(solverScope);
        }
    }

    public String toString() {
        return "Bridge(" + this.selectionCacheLifecycleListener + ")";
    }
}

