/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.decorator;

import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionFilter;
import org.drools.planner.core.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.drools.planner.core.heuristic.selector.move.AbstractMoveSelector;
import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.score.director.ScoreDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringMoveSelector
extends AbstractMoveSelector {
    protected final MoveSelector childMoveSelector;
    protected final List<SelectionFilter> moveFilterList;
    protected final boolean bailOutEnabled;
    protected ScoreDirector scoreDirector = null;

    public FilteringMoveSelector(MoveSelector childMoveSelector, List<SelectionFilter> moveFilterList) {
        this.childMoveSelector = childMoveSelector;
        this.moveFilterList = moveFilterList;
        this.bailOutEnabled = childMoveSelector.isNeverEnding();
        this.solverPhaseLifecycleSupport.addEventListener(childMoveSelector);
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public boolean isContinuous() {
        return this.childMoveSelector.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childMoveSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.childMoveSelector.getSize();
    }

    @Override
    public Iterator<Move> iterator() {
        return new JustInTimeFilteringMoveIterator(this.childMoveSelector.iterator());
    }

    protected long determineBailOutSize() {
        return this.childMoveSelector.getSize() * 10L;
    }

    private boolean accept(ScoreDirector scoreDirector, Move move) {
        for (SelectionFilter moveFilter : this.moveFilterList) {
            if (moveFilter.accept(scoreDirector, move)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Filtering(" + this.childMoveSelector + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JustInTimeFilteringMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private final Iterator<Move> childMoveIterator;

        public JustInTimeFilteringMoveIterator(Iterator<Move> childMoveIterator) {
            this.childMoveIterator = childMoveIterator;
            this.createUpcomingSelection();
        }

        @Override
        protected void createUpcomingSelection() {
            Move next;
            long attemptsBeforeBailOut;
            long l = attemptsBeforeBailOut = FilteringMoveSelector.this.bailOutEnabled ? FilteringMoveSelector.this.determineBailOutSize() : 0L;
            do {
                if (!this.childMoveIterator.hasNext()) {
                    next = null;
                    break;
                }
                if (!FilteringMoveSelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    FilteringMoveSelector.this.logger.warn("Bailing out of neverEnding selector ({}) to avoid infinite loop.", (Object)FilteringMoveSelector.this);
                    next = null;
                    break;
                }
                --attemptsBeforeBailOut;
            } while (!FilteringMoveSelector.this.accept(FilteringMoveSelector.this.scoreDirector, next = this.childMoveIterator.next()));
            this.upcomingSelection = next;
        }
    }
}

