/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.factory;

import java.util.Iterator;
import org.drools.planner.core.heuristic.selector.move.AbstractMoveSelector;
import org.drools.planner.core.heuristic.selector.move.factory.MoveIteratorFactory;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.score.director.ScoreDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveIteratorFactoryToMoveSelectorBridge
extends AbstractMoveSelector {
    protected final MoveIteratorFactory moveIteratorFactory;
    protected final boolean randomSelection;
    protected ScoreDirector scoreDirector = null;

    public MoveIteratorFactoryToMoveSelectorBridge(MoveIteratorFactory moveIteratorFactory, boolean randomSelection) {
        this.moveIteratorFactory = moveIteratorFactory;
        this.randomSelection = randomSelection;
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        long size = this.moveIteratorFactory.getSize(this.scoreDirector);
        if (size < 0L) {
            throw new IllegalStateException("The moveIteratorFactoryClass (" + this.moveIteratorFactory.getClass() + ") does not know its size (" + size + ") but a correct size is required in this Solver configuration.");
        }
        return size;
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return this.moveIteratorFactory.createOriginalMoveIterator(this.scoreDirector);
        }
        return this.moveIteratorFactory.createRandomMoveIterator(this.scoreDirector, this.workingRandom);
    }

    public String toString() {
        return "MoveIteratorFactory(" + this.moveIteratorFactory.getClass() + ")";
    }
}

