/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.generic;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.iterator.AbstractOriginalSwapIterator;
import org.drools.planner.core.heuristic.selector.common.iterator.AbstractRandomSwapIterator;
import org.drools.planner.core.heuristic.selector.common.iterator.ListIterable;
import org.drools.planner.core.heuristic.selector.entity.pillar.PillarSelector;
import org.drools.planner.core.heuristic.selector.move.generic.GenericMoveSelector;
import org.drools.planner.core.heuristic.selector.move.generic.PillarSwapMove;
import org.drools.planner.core.move.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PillarSwapMoveSelector
extends GenericMoveSelector {
    protected final PillarSelector leftPillarSelector;
    protected final PillarSelector rightPillarSelector;
    protected final Collection<PlanningVariableDescriptor> variableDescriptors;
    protected final boolean randomSelection;

    public PillarSwapMoveSelector(PillarSelector leftPillarSelector, PillarSelector rightPillarSelector, Collection<PlanningVariableDescriptor> variableDescriptors, boolean randomSelection) {
        this.leftPillarSelector = leftPillarSelector;
        this.rightPillarSelector = rightPillarSelector;
        this.variableDescriptors = variableDescriptors;
        this.randomSelection = randomSelection;
        Class<?> leftEntityClass = leftPillarSelector.getEntityDescriptor().getPlanningEntityClass();
        if (!leftEntityClass.equals(rightPillarSelector.getEntityDescriptor().getPlanningEntityClass())) {
            throw new IllegalStateException("The selector (" + this + ") has a leftPillarSelector's planningEntityClass (" + leftEntityClass + ") which is not equal to the rightPillarSelector's planningEntityClass (" + rightPillarSelector.getEntityDescriptor().getPlanningEntityClass() + ").");
        }
        for (PlanningVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!leftEntityClass.equals(variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass())) {
                throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") with a planningEntityClass (" + variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass() + ") which is not equal to the leftPillarSelector's planningEntityClass (" + leftEntityClass + ").");
            }
            if (!variableDescriptor.isChained()) continue;
            throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(leftPillarSelector);
        if (leftPillarSelector != rightPillarSelector) {
            this.solverPhaseLifecycleSupport.addEventListener(rightPillarSelector);
        }
    }

    @Override
    public boolean isContinuous() {
        return this.leftPillarSelector.isContinuous() || this.rightPillarSelector.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.leftPillarSelector.isNeverEnding() || this.rightPillarSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return AbstractOriginalSwapIterator.getSize(this.leftPillarSelector, this.rightPillarSelector);
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new AbstractOriginalSwapIterator<Move, List<Object>>((ListIterable)this.leftPillarSelector, (ListIterable)this.rightPillarSelector){

                @Override
                protected Move newSwapSelection(List<Object> leftSubSelection, List<Object> rightSubSelection) {
                    return new PillarSwapMove(PillarSwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection);
                }
            };
        }
        return new AbstractRandomSwapIterator<Move, List<Object>>((Iterable)this.leftPillarSelector, (Iterable)this.rightPillarSelector){

            @Override
            protected Move newSwapSelection(List<Object> leftSubSelection, List<Object> rightSubSelection) {
                return new PillarSwapMove(PillarSwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftPillarSelector + ", " + this.rightPillarSelector + ")";
    }
}

