/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.generic.chained;

import java.util.Iterator;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.iterator.AbstractOriginalSwapIterator;
import org.drools.planner.core.heuristic.selector.common.iterator.AbstractRandomSwapIterator;
import org.drools.planner.core.heuristic.selector.common.iterator.ListIterable;
import org.drools.planner.core.heuristic.selector.move.generic.GenericMoveSelector;
import org.drools.planner.core.heuristic.selector.move.generic.chained.SubChainReversingSwapMove;
import org.drools.planner.core.heuristic.selector.move.generic.chained.SubChainSwapMove;
import org.drools.planner.core.heuristic.selector.value.chained.SubChain;
import org.drools.planner.core.heuristic.selector.value.chained.SubChainSelector;
import org.drools.planner.core.move.Move;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubChainSwapMoveSelector
extends GenericMoveSelector {
    protected final SubChainSelector leftSubChainSelector;
    protected final SubChainSelector rightSubChainSelector;
    protected final PlanningVariableDescriptor variableDescriptor;
    protected final boolean randomSelection;
    protected final boolean selectReversingMoveToo;

    public SubChainSwapMoveSelector(SubChainSelector leftSubChainSelector, SubChainSelector rightSubChainSelector, boolean randomSelection, boolean selectReversingMoveToo) {
        this.leftSubChainSelector = leftSubChainSelector;
        this.rightSubChainSelector = rightSubChainSelector;
        this.randomSelection = randomSelection;
        this.selectReversingMoveToo = selectReversingMoveToo;
        this.variableDescriptor = leftSubChainSelector.getVariableDescriptor();
        if (leftSubChainSelector.getVariableDescriptor() != rightSubChainSelector.getVariableDescriptor()) {
            throw new IllegalStateException("The selector (" + this + ") has a leftSubChainSelector's variableDescriptor (" + leftSubChainSelector.getVariableDescriptor() + ") which is not equal to the rightSubChainSelector's variableDescriptor (" + rightSubChainSelector.getVariableDescriptor() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(leftSubChainSelector);
        if (leftSubChainSelector != rightSubChainSelector) {
            this.solverPhaseLifecycleSupport.addEventListener(rightSubChainSelector);
        }
    }

    @Override
    public boolean isContinuous() {
        return this.leftSubChainSelector.isContinuous() || this.rightSubChainSelector.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.leftSubChainSelector.isNeverEnding() || this.rightSubChainSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return AbstractOriginalSwapIterator.getSize(this.leftSubChainSelector, this.rightSubChainSelector);
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new AbstractOriginalSwapIterator<Move, SubChain>((ListIterable)this.leftSubChainSelector, (ListIterable)this.rightSubChainSelector){
                private Move nextReversingSelection;
                {
                    this.nextReversingSelection = null;
                }

                @Override
                protected void createUpcomingSelection() {
                    if (SubChainSwapMoveSelector.this.selectReversingMoveToo && this.nextReversingSelection != null) {
                        this.upcomingSelection = this.nextReversingSelection;
                        this.nextReversingSelection = null;
                        return;
                    }
                    super.createUpcomingSelection();
                }

                @Override
                protected Move newSwapSelection(SubChain leftSubSelection, SubChain rightSubSelection) {
                    if (SubChainSwapMoveSelector.this.selectReversingMoveToo) {
                        this.nextReversingSelection = new SubChainReversingSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, leftSubSelection, rightSubSelection);
                    }
                    return new SubChainSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, leftSubSelection, rightSubSelection);
                }
            };
        }
        return new AbstractRandomSwapIterator<Move, SubChain>((Iterable)this.leftSubChainSelector, (Iterable)this.rightSubChainSelector){

            @Override
            protected Move newSwapSelection(SubChain leftSubSelection, SubChain rightSubSelection) {
                boolean reversing = SubChainSwapMoveSelector.this.selectReversingMoveToo ? SubChainSwapMoveSelector.this.workingRandom.nextBoolean() : false;
                return reversing ? new SubChainReversingSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, leftSubSelection, rightSubSelection) : new SubChainSwapMove(SubChainSwapMoveSelector.this.variableDescriptor, leftSubSelection, rightSubSelection);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftSubChainSelector + ", " + this.rightSubChainSelector + ")";
    }
}

