/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.termination;

import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.termination.AbstractTermination;

public class TimeMillisSpendTermination
extends AbstractTermination {
    private long maximumTimeMillisSpend;

    public void setMaximumTimeMillisSpend(long maximumTimeMillisSpend) {
        this.maximumTimeMillisSpend = maximumTimeMillisSpend;
        if (maximumTimeMillisSpend <= 0L) {
            throw new IllegalArgumentException("Property maximumTimeMillisSpend (" + maximumTimeMillisSpend + ") must be greater than 0.");
        }
    }

    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        long solverTimeMillisSpend = solverScope.calculateTimeMillisSpend();
        return this.isTerminated(solverTimeMillisSpend);
    }

    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        long phaseTimeMillisSpend = phaseScope.calculatePhaseTimeMillisSpend();
        return this.isTerminated(phaseTimeMillisSpend);
    }

    private boolean isTerminated(long timeMillisSpend) {
        return timeMillisSpend >= this.maximumTimeMillisSpend;
    }

    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        long solverTimeMillisSpend = solverScope.calculateTimeMillisSpend();
        return this.calculateTimeGradient(solverTimeMillisSpend);
    }

    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        long phaseTimeMillisSpend = phaseScope.calculatePhaseTimeMillisSpend();
        return this.calculateTimeGradient(phaseTimeMillisSpend);
    }

    private double calculateTimeGradient(double timeMillisSpend) {
        double timeGradient = timeMillisSpend / (double)this.maximumTimeMillisSpend;
        return Math.min(timeGradient, 1.0);
    }
}

