/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.drools.planner.benchmark.api.PlannerBenchmark;
import org.drools.planner.benchmark.api.ranking.SolverBenchmarkRankingWeightFactory;
import org.drools.planner.benchmark.config.SolverBenchmarkConfig;
import org.drools.planner.benchmark.core.DefaultPlannerBenchmark;
import org.drools.planner.benchmark.core.ProblemBenchmark;
import org.drools.planner.benchmark.core.SolverBenchmark;
import org.drools.planner.benchmark.core.ranking.SolverBenchmarkRankingType;
import org.drools.planner.benchmark.core.ranking.TotalRankSolverBenchmarkRankingWeightFactory;
import org.drools.planner.benchmark.core.ranking.TotalScoreSolverBenchmarkRankingComparator;
import org.drools.planner.benchmark.core.ranking.WorstScoreSolverBenchmarkRankingComparator;
import org.drools.planner.config.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="plannerBenchmark")
public class PlannerBenchmarkConfig {
    public static final String PARALLEL_BENCHMARK_COUNT_AUTO = "AUTO";
    public static final String AVAILABLE_PROCESSOR_COUNT = "availableProcessorCount";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private File benchmarkDirectory = null;
    private String parallelBenchmarkCount = null;
    private Long warmUpTimeMillisSpend = null;
    private Long warmUpSecondsSpend = null;
    private Long warmUpMinutesSpend = null;
    private Long warmUpHoursSpend = null;
    private Locale benchmarkReportLocale = null;
    private SolverBenchmarkRankingType solverBenchmarkRankingType = null;
    private Class<Comparator<SolverBenchmark>> solverBenchmarkRankingComparatorClass = null;
    private Class<SolverBenchmarkRankingWeightFactory> solverBenchmarkRankingWeightFactoryClass = null;
    @XStreamAlias(value="inheritedSolverBenchmark")
    private SolverBenchmarkConfig inheritedSolverBenchmarkConfig = null;
    @XStreamImplicit(itemFieldName="solverBenchmark")
    private List<SolverBenchmarkConfig> solverBenchmarkConfigList = null;

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public String getParallelBenchmarkCount() {
        return this.parallelBenchmarkCount;
    }

    public void setParallelBenchmarkCount(String parallelBenchmarkCount) {
        this.parallelBenchmarkCount = parallelBenchmarkCount;
    }

    public Long getWarmUpTimeMillisSpend() {
        return this.warmUpTimeMillisSpend;
    }

    public void setWarmUpTimeMillisSpend(Long warmUpTimeMillisSpend) {
        this.warmUpTimeMillisSpend = warmUpTimeMillisSpend;
    }

    public Long getWarmUpSecondsSpend() {
        return this.warmUpSecondsSpend;
    }

    public void setWarmUpSecondsSpend(Long warmUpSecondsSpend) {
        this.warmUpSecondsSpend = warmUpSecondsSpend;
    }

    public Long getWarmUpMinutesSpend() {
        return this.warmUpMinutesSpend;
    }

    public void setWarmUpMinutesSpend(Long warmUpMinutesSpend) {
        this.warmUpMinutesSpend = warmUpMinutesSpend;
    }

    public Long getWarmUpHoursSpend() {
        return this.warmUpHoursSpend;
    }

    public void setWarmUpHoursSpend(Long warmUpHoursSpend) {
        this.warmUpHoursSpend = warmUpHoursSpend;
    }

    public Locale getBenchmarkReportLocale() {
        return this.benchmarkReportLocale;
    }

    public void setBenchmarkReportLocale(Locale benchmarkReportLocale) {
        this.benchmarkReportLocale = benchmarkReportLocale;
    }

    public SolverBenchmarkRankingType getSolverBenchmarkRankingType() {
        return this.solverBenchmarkRankingType;
    }

    public void setSolverBenchmarkRankingType(SolverBenchmarkRankingType solverBenchmarkRankingType) {
        this.solverBenchmarkRankingType = solverBenchmarkRankingType;
    }

    public Class<Comparator<SolverBenchmark>> getSolverBenchmarkRankingComparatorClass() {
        return this.solverBenchmarkRankingComparatorClass;
    }

    public void setSolverBenchmarkRankingComparatorClass(Class<Comparator<SolverBenchmark>> solverBenchmarkRankingComparatorClass) {
        this.solverBenchmarkRankingComparatorClass = solverBenchmarkRankingComparatorClass;
    }

    public Class<SolverBenchmarkRankingWeightFactory> getSolverBenchmarkRankingWeightFactoryClass() {
        return this.solverBenchmarkRankingWeightFactoryClass;
    }

    public void setSolverBenchmarkRankingWeightFactoryClass(Class<SolverBenchmarkRankingWeightFactory> solverBenchmarkRankingWeightFactoryClass) {
        this.solverBenchmarkRankingWeightFactoryClass = solverBenchmarkRankingWeightFactoryClass;
    }

    public SolverBenchmarkConfig getInheritedSolverBenchmarkConfig() {
        return this.inheritedSolverBenchmarkConfig;
    }

    public void setInheritedSolverBenchmarkConfig(SolverBenchmarkConfig inheritedSolverBenchmarkConfig) {
        this.inheritedSolverBenchmarkConfig = inheritedSolverBenchmarkConfig;
    }

    public List<SolverBenchmarkConfig> getSolverBenchmarkConfigList() {
        return this.solverBenchmarkConfigList;
    }

    public void setSolverBenchmarkConfigList(List<SolverBenchmarkConfig> solverBenchmarkConfigList) {
        this.solverBenchmarkConfigList = solverBenchmarkConfigList;
    }

    public PlannerBenchmark buildPlannerBenchmark() {
        this.validate();
        this.generateSolverBenchmarkConfigNames();
        this.inherit();
        DefaultPlannerBenchmark plannerBenchmark = new DefaultPlannerBenchmark();
        plannerBenchmark.setBenchmarkDirectory(this.benchmarkDirectory);
        plannerBenchmark.setParallelBenchmarkCount(this.resolveParallelBenchmarkCount());
        plannerBenchmark.setWarmUpTimeMillisSpend(this.calculateWarmUpTimeMillisSpendTotal());
        plannerBenchmark.getBenchmarkReport().setLocale(this.benchmarkReportLocale == null ? Locale.getDefault() : this.benchmarkReportLocale);
        this.supplySolverBenchmarkRanking(plannerBenchmark);
        ArrayList<SolverBenchmark> solverBenchmarkList = new ArrayList<SolverBenchmark>(this.solverBenchmarkConfigList.size());
        ArrayList<ProblemBenchmark> unifiedProblemBenchmarkList = new ArrayList<ProblemBenchmark>();
        plannerBenchmark.setUnifiedProblemBenchmarkList(unifiedProblemBenchmarkList);
        for (SolverBenchmarkConfig solverBenchmarkConfig : this.solverBenchmarkConfigList) {
            SolverBenchmark solverBenchmark = solverBenchmarkConfig.buildSolverBenchmark(plannerBenchmark);
            solverBenchmarkList.add(solverBenchmark);
        }
        plannerBenchmark.setSolverBenchmarkList(solverBenchmarkList);
        return plannerBenchmark;
    }

    protected void validate() {
        if (this.solverBenchmarkConfigList == null || this.solverBenchmarkConfigList.isEmpty()) {
            throw new IllegalArgumentException("Configure at least 1 <solverBenchmark> in the <plannerBenchmark> configuration.");
        }
    }

    protected void generateSolverBenchmarkConfigNames() {
        HashSet<String> nameSet = new HashSet<String>(this.solverBenchmarkConfigList.size());
        LinkedHashSet<SolverBenchmarkConfig> noNameBenchmarkConfigSet = new LinkedHashSet<SolverBenchmarkConfig>(this.solverBenchmarkConfigList.size());
        for (SolverBenchmarkConfig solverBenchmarkConfig : this.solverBenchmarkConfigList) {
            if (solverBenchmarkConfig.getName() != null) {
                boolean unique = nameSet.add(solverBenchmarkConfig.getName());
                if (unique) continue;
                throw new IllegalStateException("The benchmark name (" + solverBenchmarkConfig.getName() + ") is used in more than 1 benchmark.");
            }
            noNameBenchmarkConfigSet.add(solverBenchmarkConfig);
        }
        int generatedNameIndex = 0;
        for (SolverBenchmarkConfig solverBenchmarkConfig : noNameBenchmarkConfigSet) {
            String generatedName = "Config_" + generatedNameIndex;
            while (nameSet.contains(generatedName)) {
                generatedName = "Config_" + ++generatedNameIndex;
            }
            solverBenchmarkConfig.setName(generatedName);
            ++generatedNameIndex;
        }
    }

    protected void inherit() {
        if (this.inheritedSolverBenchmarkConfig != null) {
            for (SolverBenchmarkConfig solverBenchmarkConfig : this.solverBenchmarkConfigList) {
                solverBenchmarkConfig.inherit(this.inheritedSolverBenchmarkConfig);
            }
        }
    }

    protected void supplySolverBenchmarkRanking(DefaultPlannerBenchmark plannerBenchmark) {
        if (this.solverBenchmarkRankingType != null && this.solverBenchmarkRankingComparatorClass != null) {
            throw new IllegalStateException("The PlannerBenchmark cannot have a solverBenchmarkRankingType (" + (Object)((Object)this.solverBenchmarkRankingType) + ") and a solverBenchmarkRankingComparatorClass (" + this.solverBenchmarkRankingComparatorClass.getName() + ") at the same time.");
        }
        if (this.solverBenchmarkRankingType != null && this.solverBenchmarkRankingWeightFactoryClass != null) {
            throw new IllegalStateException("The PlannerBenchmark cannot have a solverBenchmarkRankingType (" + (Object)((Object)this.solverBenchmarkRankingType) + ") and a solverBenchmarkRankingWeightFactoryClass (" + this.solverBenchmarkRankingWeightFactoryClass.getName() + ") at the same time.");
        }
        if (this.solverBenchmarkRankingComparatorClass != null && this.solverBenchmarkRankingWeightFactoryClass != null) {
            throw new IllegalStateException("The PlannerBenchmark cannot have a solverBenchmarkRankingComparatorClass (" + this.solverBenchmarkRankingComparatorClass.getName() + ") and a solverBenchmarkRankingWeightFactoryClass (" + this.solverBenchmarkRankingWeightFactoryClass.getName() + ") at the same time.");
        }
        Comparator<SolverBenchmark> solverBenchmarkRankingComparator = null;
        SolverBenchmarkRankingWeightFactory solverBenchmarkRankingWeightFactory = null;
        if (this.solverBenchmarkRankingType != null) {
            switch (this.solverBenchmarkRankingType) {
                case TOTAL_SCORE: {
                    solverBenchmarkRankingComparator = new TotalScoreSolverBenchmarkRankingComparator();
                    break;
                }
                case WORST_SCORE: {
                    solverBenchmarkRankingComparator = new WorstScoreSolverBenchmarkRankingComparator();
                    break;
                }
                case TOTAL_RANKING: {
                    solverBenchmarkRankingWeightFactory = new TotalRankSolverBenchmarkRankingWeightFactory();
                    break;
                }
                default: {
                    throw new IllegalStateException("The solverBenchmarkRankingType (" + (Object)((Object)this.solverBenchmarkRankingType) + ") is not implemented");
                }
            }
        }
        if (this.solverBenchmarkRankingComparatorClass != null) {
            solverBenchmarkRankingComparator = (Comparator)ConfigUtils.newInstance((Object)this, (String)"solverBenchmarkRankingComparatorClass", this.solverBenchmarkRankingComparatorClass);
        }
        if (this.solverBenchmarkRankingWeightFactoryClass != null) {
            try {
                solverBenchmarkRankingWeightFactory = this.solverBenchmarkRankingWeightFactoryClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("solverBenchmarkComparatorFactoryClass (" + this.solverBenchmarkRankingWeightFactoryClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("solverBenchmarkComparatorFactoryClass (" + this.solverBenchmarkRankingWeightFactoryClass.getName() + ") does not have a public no-arg constructor", e);
            }
        }
        if (solverBenchmarkRankingComparator != null) {
            plannerBenchmark.setSolverBenchmarkRankingComparator(solverBenchmarkRankingComparator);
        } else if (solverBenchmarkRankingWeightFactory != null) {
            plannerBenchmark.setSolverBenchmarkRankingWeightFactory(solverBenchmarkRankingWeightFactory);
        } else {
            plannerBenchmark.setSolverBenchmarkRankingComparator(new TotalScoreSolverBenchmarkRankingComparator());
        }
    }

    protected int resolveParallelBenchmarkCount() {
        int resolvedParallelBenchmarkCount;
        int availableProcessorCount = Runtime.getRuntime().availableProcessors();
        if (this.parallelBenchmarkCount == null) {
            resolvedParallelBenchmarkCount = 1;
        } else if (this.parallelBenchmarkCount.equals(PARALLEL_BENCHMARK_COUNT_AUTO)) {
            resolvedParallelBenchmarkCount = availableProcessorCount <= 2 ? 1 : (availableProcessorCount <= 4 ? 2 : availableProcessorCount / 2 + 1);
        } else {
            Object scriptResult;
            String scriptLanguage = "JavaScript";
            ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName(scriptLanguage);
            scriptEngine.put(AVAILABLE_PROCESSOR_COUNT, availableProcessorCount);
            try {
                scriptResult = scriptEngine.eval(this.parallelBenchmarkCount);
            }
            catch (ScriptException e) {
                throw new IllegalArgumentException("The parallelBenchmarkCount (" + this.parallelBenchmarkCount + ") is not " + PARALLEL_BENCHMARK_COUNT_AUTO + " and cannot be parsed in " + scriptLanguage + " with the variables ([" + AVAILABLE_PROCESSOR_COUNT + "]).", e);
            }
            if (!(scriptResult instanceof Number)) {
                throw new IllegalArgumentException("The parallelBenchmarkCount (" + this.parallelBenchmarkCount + ") is resolved to scriptResult (" + scriptResult + ") in " + scriptLanguage + " and is not a Number.");
            }
            resolvedParallelBenchmarkCount = ((Number)scriptResult).intValue();
        }
        if (resolvedParallelBenchmarkCount < 1) {
            throw new IllegalArgumentException("The parallelBenchmarkCount (" + this.parallelBenchmarkCount + ") resulted in a resolvedParallelBenchmarkCount (" + resolvedParallelBenchmarkCount + ") that is lower than 1.");
        }
        if (resolvedParallelBenchmarkCount > availableProcessorCount) {
            this.logger.warn("Because the resolvedParallelBenchmarkCount (" + resolvedParallelBenchmarkCount + ") is higher than the availableProcessorCount (" + availableProcessorCount + "), it is reduced to availableProcessorCount.");
            resolvedParallelBenchmarkCount = availableProcessorCount;
        }
        return resolvedParallelBenchmarkCount;
    }

    protected long calculateWarmUpTimeMillisSpendTotal() {
        long warmUpTimeMillisSpendTotal = 0L;
        if (this.warmUpTimeMillisSpend != null) {
            warmUpTimeMillisSpendTotal += this.warmUpTimeMillisSpend.longValue();
        }
        if (this.warmUpSecondsSpend != null) {
            warmUpTimeMillisSpendTotal += this.warmUpSecondsSpend * 1000L;
        }
        if (this.warmUpMinutesSpend != null) {
            warmUpTimeMillisSpendTotal += this.warmUpMinutesSpend * 60000L;
        }
        if (this.warmUpHoursSpend != null) {
            warmUpTimeMillisSpendTotal += this.warmUpHoursSpend * 3600000L;
        }
        return warmUpTimeMillisSpendTotal;
    }
}

