/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core.statistic;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.drools.planner.benchmark.core.ProblemBenchmark;
import org.drools.planner.benchmark.core.SingleBenchmark;
import org.drools.planner.benchmark.core.statistic.ProblemStatistic;
import org.drools.planner.benchmark.core.statistic.ProblemStatisticType;
import org.jfree.chart.JFreeChart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProblemStatistic
implements ProblemStatistic {
    protected final ProblemBenchmark problemBenchmark;
    protected final ProblemStatisticType problemStatisticType;
    protected File csvStatisticFile = null;
    protected List<String> warningList = null;

    protected AbstractProblemStatistic(ProblemBenchmark problemBenchmark, ProblemStatisticType problemStatisticType) {
        this.problemBenchmark = problemBenchmark;
        this.problemStatisticType = problemStatisticType;
    }

    public ProblemBenchmark getProblemBenchmark() {
        return this.problemBenchmark;
    }

    @Override
    public ProblemStatisticType getProblemStatisticType() {
        return this.problemStatisticType;
    }

    @Override
    public String getAnchorId() {
        return this.problemBenchmark.getName() + "_" + this.problemStatisticType.name();
    }

    @Override
    public String getCsvFilePath() {
        return this.toFilePath(this.csvStatisticFile);
    }

    @Override
    public List<String> getWarningList() {
        return this.warningList;
    }

    protected String toFilePath(File file) {
        return this.problemBenchmark.getProblemReportDirectory().getName() + "/" + file.getName();
    }

    @Override
    public void writeStatistic() {
        this.warningList = new ArrayList<String>();
        this.fillWarningList();
        this.writeCsvStatistic();
        this.writeGraphStatistic();
    }

    protected void fillWarningList() {
    }

    protected abstract void writeCsvStatistic();

    protected abstract void writeGraphStatistic();

    protected File writeChartToImageFile(JFreeChart chart, String fileNameBase) {
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File chartFile = new File(this.problemBenchmark.getProblemReportDirectory(), fileNameBase + ".png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(chartFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing chartFile: " + chartFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return chartFile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProblemStatisticCsvLine
    implements Comparable<ProblemStatisticCsvLine> {
        protected long timeMillisSpend;
        protected Map<SingleBenchmark, String> valueMap = new HashMap<SingleBenchmark, String>();

        private ProblemStatisticCsvLine(long timeMillisSpend) {
            this.timeMillisSpend = timeMillisSpend;
        }

        public long getTimeMillisSpend() {
            return this.timeMillisSpend;
        }

        public Map<SingleBenchmark, String> getValueMap() {
            return this.valueMap;
        }

        @Override
        public int compareTo(ProblemStatisticCsvLine other) {
            return this.timeMillisSpend < other.timeMillisSpend ? -1 : (this.timeMillisSpend > other.timeMillisSpend ? 1 : 0);
        }
    }

    public class ProblemStatisticCsv {
        private Map<Long, ProblemStatisticCsvLine> timeToLineMap = new HashMap<Long, ProblemStatisticCsvLine>();

        public void addPoint(SingleBenchmark singleBenchmark, long timeMillisSpend, long value) {
            this.addRawPoint(singleBenchmark, timeMillisSpend, Long.toString(value));
        }

        public void addPoint(SingleBenchmark singleBenchmark, long timeMillisSpend, double value) {
            this.addRawPoint(singleBenchmark, timeMillisSpend, Double.toString(value));
        }

        public void addPoint(SingleBenchmark singleBenchmark, long timeMillisSpend, String value) {
            this.addRawPoint(singleBenchmark, timeMillisSpend, "\"" + value.replaceAll("\"", "\"\"") + "\"");
        }

        private void addRawPoint(SingleBenchmark singleBenchmark, long timeMillisSpend, String value) {
            ProblemStatisticCsvLine line = this.findOrCreateLine(timeMillisSpend);
            line.getValueMap().put(singleBenchmark, value);
        }

        protected ProblemStatisticCsvLine findOrCreateLine(long timeMillisSpend) {
            ProblemStatisticCsvLine line = this.timeToLineMap.get(timeMillisSpend);
            if (line == null) {
                line = new ProblemStatisticCsvLine(timeMillisSpend);
                this.timeToLineMap.put(timeMillisSpend, line);
            }
            return line;
        }

        public void writeCsvStatisticFile() {
            ArrayList<ProblemStatisticCsvLine> lines = new ArrayList<ProblemStatisticCsvLine>(this.timeToLineMap.values());
            Collections.sort(lines);
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(AbstractProblemStatistic.this.csvStatisticFile), "UTF-8");
                ((Writer)writer).append("\"TimeMillisSpend\"");
                for (SingleBenchmark singleBenchmark : AbstractProblemStatistic.this.problemBenchmark.getSingleBenchmarkList()) {
                    ((Writer)writer).append(",\"").append(singleBenchmark.getSolverBenchmark().getName().replaceAll("\\\"", "\\\"")).append("\"");
                }
                ((Writer)writer).append("\n");
                for (ProblemStatisticCsvLine line : lines) {
                    writer.write(Long.toString(line.getTimeMillisSpend()));
                    for (SingleBenchmark singleBenchmark : AbstractProblemStatistic.this.problemBenchmark.getSingleBenchmarkList()) {
                        ((Writer)writer).append(",");
                        String value = line.getValueMap().get(singleBenchmark);
                        if (value == null) continue;
                        ((Writer)writer).append(value);
                    }
                    ((Writer)writer).append("\n");
                }
            }
            catch (IOException e) {
                try {
                    throw new IllegalArgumentException("Problem writing csvStatisticFile: " + AbstractProblemStatistic.this.csvStatisticFile, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
    }
}

