/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import org.drools.core.util.StringUtils;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;

public class JavaRuleClassBuilder
implements RuleClassBuilder {
    public String buildRule(RuleBuildContext context) {
        if (context.getMethods().isEmpty()) {
            return null;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder buffer = new StringBuilder();
        buffer.append("package ").append(context.getPkg().getName()).append(";").append(lineSeparator);
        for (String s : context.getPkg().getImports().keySet()) {
            buffer.append("import ").append(s).append(";");
        }
        for (String s : context.getPkg().getStaticImports()) {
            buffer.append("import static ").append(s).append(";");
        }
        buffer.append(lineSeparator);
        RuleDescr ruleDescr = context.getRuleDescr();
        buffer.append("public class ").append(StringUtils.ucFirst((String)ruleDescr.getClassName())).append(" {").append(lineSeparator);
        buffer.append("    private static final long serialVersionUID = 510l;").append(lineSeparator);
        int size = context.getMethods().size() - 1;
        for (int i = 0; i < size; ++i) {
            buffer.append(context.getMethods().get(i)).append(lineSeparator);
        }
        String[] lines = buffer.toString().split(lineSeparator, -1);
        ruleDescr.setConsequenceOffset(lines.length);
        buffer.append(context.getMethods().get(context.getMethods().size() - 1)).append(lineSeparator);
        buffer.append("}");
        return buffer.toString();
    }
}

