/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.drools.factmodel.traits.TypeHierarchy;
import org.drools.util.AbstractCodedHierarchyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedTypeHierarchy<T>
extends TypeHierarchy<T>
implements Externalizable {
    protected transient Map<T, AbstractCodedHierarchyImpl.HierNode<T>> cache;

    public IndexedTypeHierarchy() {
        this.cache = new HashMap<T, AbstractCodedHierarchyImpl.HierNode<T>>();
    }

    public IndexedTypeHierarchy(T topElement, BitSet topKey, T bottomElement, BitSet bottomKey) {
        this.setTopCode(topKey);
        this.setBottomCode(bottomKey);
        this.cache = new HashMap<T, AbstractCodedHierarchyImpl.HierNode<T>>();
        this.addMember(topElement, topKey);
        this.addMember(bottomElement, bottomKey);
    }

    @Override
    protected AbstractCodedHierarchyImpl.HierNode<T> getNode(T name) {
        return this.cache.get(name);
    }

    @Override
    protected void add(AbstractCodedHierarchyImpl.HierNode<T> node) {
        super.add(node);
        this.cache.put(node.getValue(), node);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("*****************************************\n");
        int len = 0;
        for (AbstractCodedHierarchyImpl.HierNode node : this.getNodes()) {
            len = Math.max(len, this.numBit(node.getBitMask()));
        }
        for (AbstractCodedHierarchyImpl.HierNode node : this.getNodes()) {
            builder.append(node.toString(len)).append("\n");
        }
        builder.append("*****************************************\n");
        builder.append(this.getSortedMap()).append("\n");
        builder.append("*****************************************\n");
        return builder.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
    }
}

