/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.ObjectMarshallingStrategyAcceptor;
import org.drools.marshalling.impl.PersisterHelper;

public class SerializablePlaceholderResolverStrategy
implements ObjectMarshallingStrategy {
    private int index;
    private ObjectMarshallingStrategyAcceptor acceptor;

    public SerializablePlaceholderResolverStrategy(ObjectMarshallingStrategyAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Object read(ObjectInputStream os) throws IOException, ClassNotFoundException {
        return os.readObject();
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        os.writeObject(object);
    }

    public boolean accept(Object object) {
        return this.acceptor.accept(object);
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        SerializablePlaceholderStrategyContext ctx = (SerializablePlaceholderStrategyContext)context;
        int index = ctx.data.size();
        ctx.data.add(object);
        return PersisterHelper.intToByteArray(index);
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream is, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        SerializablePlaceholderStrategyContext ctx = (SerializablePlaceholderStrategyContext)context;
        return ctx.data.get(PersisterHelper.byteArrayToInt(object));
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return new SerializablePlaceholderStrategyContext();
    }

    protected static class SerializablePlaceholderStrategyContext
    implements ObjectMarshallingStrategy.Context {
        public List<Object> data = new ArrayList<Object>();

        protected SerializablePlaceholderStrategyContext() {
        }

        public void read(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.data = (List)ois.readObject();
        }

        public void write(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.data);
        }
    }
}

