/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.machinereassignment.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRange;
import org.drools.planner.api.domain.variable.ValueRangeType;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.machinereassignment.domain.MrLocation;
import org.drools.planner.examples.machinereassignment.domain.MrMachine;
import org.drools.planner.examples.machinereassignment.domain.MrNeighborhood;
import org.drools.planner.examples.machinereassignment.domain.MrProcess;
import org.drools.planner.examples.machinereassignment.domain.MrResource;
import org.drools.planner.examples.machinereassignment.domain.MrService;
import org.drools.planner.examples.machinereassignment.domain.solver.MrProcessAssignmentDifficultyComparator;

@PlanningEntity(difficultyComparatorClass=MrProcessAssignmentDifficultyComparator.class)
@XStreamAlias(value="MrProcessAssignment")
public class MrProcessAssignment
extends AbstractPersistable {
    private MrProcess process;
    private MrMachine originalMachine;
    private MrMachine machine;

    public MrProcess getProcess() {
        return this.process;
    }

    public void setProcess(MrProcess process) {
        this.process = process;
    }

    public MrMachine getOriginalMachine() {
        return this.originalMachine;
    }

    public void setOriginalMachine(MrMachine originalMachine) {
        this.originalMachine = originalMachine;
    }

    @PlanningVariable
    @ValueRange(type=ValueRangeType.FROM_SOLUTION_PROPERTY, solutionProperty="machineList")
    public MrMachine getMachine() {
        return this.machine;
    }

    public void setMachine(MrMachine machine) {
        this.machine = machine;
    }

    public MrService getService() {
        return this.process.getService();
    }

    public boolean isMoved() {
        return !ObjectUtils.equals((Object)this.originalMachine, (Object)this.machine);
    }

    public int getProcessMoveCost() {
        return this.process.getMoveCost();
    }

    public int getMachineMoveCost() {
        return this.machine == null ? 0 : this.originalMachine.getMoveCostTo(this.machine);
    }

    public MrNeighborhood getNeighborhood() {
        return this.machine == null ? null : this.machine.getNeighborhood();
    }

    public MrLocation getLocation() {
        return this.machine == null ? null : this.machine.getLocation();
    }

    public long getUsage(MrResource resource) {
        return this.process.getUsage(resource);
    }

    public String getLabel() {
        return "Process " + this.getId();
    }

    public MrProcessAssignment clone() {
        MrProcessAssignment clone = new MrProcessAssignment();
        clone.id = this.id;
        clone.process = this.process;
        clone.originalMachine = this.originalMachine;
        clone.machine = this.machine;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MrProcessAssignment) {
            MrProcessAssignment other = (MrProcessAssignment)o;
            return new EqualsBuilder().append((Object)this.process, (Object)other.process).append((Object)this.machine, (Object)other.machine).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.process).append((Object)this.machine).toHashCode();
    }

    public String toString() {
        return this.process + " @ " + this.machine;
    }
}

