/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.manners2009.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.planner.core.phase.custom.CustomSolverPhaseCommand;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.simple.DefaultSimpleScore;
import org.drools.planner.core.score.buildin.simple.SimpleScore;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.common.domain.PersistableIdComparator;
import org.drools.planner.examples.manners2009.domain.Guest;
import org.drools.planner.examples.manners2009.domain.Manners2009;
import org.drools.planner.examples.manners2009.domain.Seat;
import org.drools.planner.examples.manners2009.domain.SeatDesignation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manners2009SolutionInitializer
implements CustomSolverPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void changeWorkingSolution(ScoreDirector scoreDirector) {
        Manners2009 manners2009 = (Manners2009)scoreDirector.getWorkingSolution();
        this.initializeSeatDesignationList(scoreDirector, manners2009);
    }

    private void initializeSeatDesignationList(ScoreDirector scoreDirector, Manners2009 manners2009) {
        List<SeatDesignation> seatDesignationList = this.createSeatDesignationList(manners2009);
        List<Seat> undesignatedSeatList = manners2009.getSeatList();
        for (SeatDesignation seatDesignation : seatDesignationList) {
            Score<SimpleScore> bestScore = DefaultSimpleScore.valueOf(Integer.MIN_VALUE);
            Seat bestSeat = null;
            boolean added = false;
            for (Seat seat : undesignatedSeatList) {
                Score score;
                if (seatDesignation.getGuest().getGender() != seat.getRequiredGender()) continue;
                if (!added) {
                    scoreDirector.beforeEntityAdded(seatDesignation);
                    seatDesignation.setSeat(seat);
                    scoreDirector.afterEntityAdded(seatDesignation);
                    added = true;
                } else {
                    scoreDirector.beforeVariableChanged(seatDesignation, "seat");
                    seatDesignation.setSeat(seat);
                    scoreDirector.afterVariableChanged(seatDesignation, "seat");
                }
                if ((score = scoreDirector.calculateScore()).compareTo(bestScore) <= 0) continue;
                bestScore = score;
                bestSeat = seat;
            }
            if (bestSeat == null) {
                throw new IllegalStateException("The bestSeat (" + bestSeat + ") cannot be null.");
            }
            scoreDirector.beforeVariableChanged(seatDesignation, "seat");
            seatDesignation.setSeat(bestSeat);
            scoreDirector.afterVariableChanged(seatDesignation, "seat");
            undesignatedSeatList.remove(bestSeat);
        }
        Collections.sort(seatDesignationList, new PersistableIdComparator());
        manners2009.setSeatDesignationList(seatDesignationList);
    }

    private List<SeatDesignation> createSeatDesignationList(Manners2009 manners2009) {
        ArrayList<SeatDesignation> seatDesignationList = new ArrayList<SeatDesignation>(manners2009.getGuestList().size());
        for (Guest guest : manners2009.getGuestList()) {
            SeatDesignation seatDesignation = new SeatDesignation();
            seatDesignation.setId(guest.getId());
            seatDesignation.setGuest(guest);
            seatDesignationList.add(seatDesignation);
        }
        return seatDesignationList;
    }
}

