/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.app;

import java.util.List;
import org.drools.planner.config.XmlSolverFactory;
import org.drools.planner.core.Solver;
import org.drools.planner.examples.nqueens.domain.NQueens;
import org.drools.planner.examples.nqueens.domain.Queen;
import org.drools.planner.examples.nqueens.persistence.NQueensGenerator;

public class NQueensHelloWorld {
    public static void main(String[] args) {
        XmlSolverFactory solverFactory = new XmlSolverFactory("/org/drools/planner/examples/nqueens/solver/nqueensSolverConfig.xml");
        Solver solver = solverFactory.buildSolver();
        NQueens unsolved8Queens = new NQueensGenerator().createNQueens(8);
        solver.setPlanningProblem(unsolved8Queens);
        solver.solve();
        NQueens solved8Queens = (NQueens)solver.getBestSolution();
        System.out.println("\nSolved 8 queens:\n" + NQueensHelloWorld.toDisplayString(solved8Queens));
    }

    public static String toDisplayString(NQueens nQueens) {
        StringBuilder displayString = new StringBuilder();
        int n = nQueens.getN();
        List<Queen> queenList = nQueens.getQueenList();
        for (int row = 0; row < n; ++row) {
            for (int column = 0; column < n; ++column) {
                Queen queen = queenList.get(column);
                if (queen.getColumn().getIndex() != column) {
                    throw new IllegalStateException("The queenList is not in the expected order.");
                }
                displayString.append(" ");
                if (queen.getRow() != null && queen.getRow().getIndex() == row) {
                    displayString.append("Q");
                    continue;
                }
                displayString.append("_");
            }
            displayString.append("\n");
        }
        return displayString.toString();
    }
}

