/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.vehiclerouting.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScore;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.vehiclerouting.domain.VrpAppearance;
import org.drools.planner.examples.vehiclerouting.domain.VrpCustomer;
import org.drools.planner.examples.vehiclerouting.domain.VrpDepot;
import org.drools.planner.examples.vehiclerouting.domain.VrpLocation;
import org.drools.planner.examples.vehiclerouting.domain.VrpVehicle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="VrpSchedule")
public class VrpSchedule
extends AbstractPersistable
implements Solution<HardAndSoftScore> {
    private String name;
    private List<VrpLocation> locationList;
    private List<VrpDepot> depotList;
    private List<VrpVehicle> vehicleList;
    private List<VrpCustomer> customerList;
    private HardAndSoftScore score;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<VrpLocation> getLocationList() {
        return this.locationList;
    }

    public void setLocationList(List<VrpLocation> locationList) {
        this.locationList = locationList;
    }

    public List<VrpDepot> getDepotList() {
        return this.depotList;
    }

    public void setDepotList(List<VrpDepot> depotList) {
        this.depotList = depotList;
    }

    public List<VrpVehicle> getVehicleList() {
        return this.vehicleList;
    }

    public void setVehicleList(List<VrpVehicle> vehicleList) {
        this.vehicleList = vehicleList;
    }

    @PlanningEntityCollectionProperty
    public List<VrpCustomer> getCustomerList() {
        return this.customerList;
    }

    public void setCustomerList(List<VrpCustomer> customerList) {
        this.customerList = customerList;
    }

    @Override
    public HardAndSoftScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(HardAndSoftScore score) {
        this.score = score;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.addAll(this.locationList);
        facts.addAll(this.depotList);
        facts.addAll(this.vehicleList);
        return facts;
    }

    public VrpSchedule cloneSolution() {
        VrpSchedule clone = new VrpSchedule();
        clone.id = this.id;
        clone.name = this.name;
        clone.locationList = this.locationList;
        clone.depotList = this.depotList;
        clone.vehicleList = this.vehicleList;
        ArrayList<VrpCustomer> clonedCustomerList = new ArrayList<VrpCustomer>(this.customerList.size());
        HashMap<Long, VrpCustomer> idToClonedCustomerMap = new HashMap<Long, VrpCustomer>(this.customerList.size());
        for (VrpCustomer customer : this.customerList) {
            VrpCustomer clonedCustomer = customer.clone();
            clonedCustomerList.add(clonedCustomer);
            idToClonedCustomerMap.put(clonedCustomer.getId(), clonedCustomer);
        }
        for (VrpCustomer clonedCustomer : clonedCustomerList) {
            VrpAppearance previousAppearance = clonedCustomer.getPreviousAppearance();
            if (!(previousAppearance instanceof VrpCustomer)) continue;
            Long previousVrpCustomerId = ((VrpCustomer)previousAppearance).getId();
            clonedCustomer.setPreviousAppearance((VrpAppearance)idToClonedCustomerMap.get(previousVrpCustomerId));
        }
        clone.customerList = clonedCustomerList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof VrpSchedule)) {
            return false;
        }
        VrpSchedule other = (VrpSchedule)o;
        if (this.customerList.size() != other.customerList.size()) {
            return false;
        }
        Iterator<VrpCustomer> it = this.customerList.iterator();
        Iterator<VrpCustomer> otherIt = other.customerList.iterator();
        while (it.hasNext()) {
            VrpCustomer otherCustomer;
            VrpCustomer customer = it.next();
            if (customer.solutionEquals(otherCustomer = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (VrpCustomer customer : this.customerList) {
            hashCodeBuilder.append(customer.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

