/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.examination.solver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.calculator.DefaultHardAndSoftConstraintScoreCalculator;
import org.drools.planner.core.score.calculator.ScoreCalculator;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.app.LoggingTest;
import org.drools.planner.examples.examination.domain.Exam;
import org.drools.planner.examples.examination.domain.Examination;
import org.drools.planner.examples.examination.domain.Room;
import org.drools.planner.examples.examination.persistence.ExaminationDaoImpl;
import org.drools.planner.examples.examination.solver.move.ExaminationMoveHelper;
import org.junit.Test;

public class ExaminationScoreRulesTest
extends LoggingTest {
    @Test
    public void moveRoom() {
        LocalSearchSolverScope localSearchSolverScope = new LocalSearchSolverScope();
        localSearchSolverScope.setRuleBase(this.buildRuleBase());
        localSearchSolverScope.setWorkingScoreCalculator((ScoreCalculator)new DefaultHardAndSoftConstraintScoreCalculator());
        Examination examination = (Examination)new ExaminationDaoImpl().readSolution(this.getClass().getResourceAsStream("/org/drools/planner/examples/examination/data/testExaminationScoreRules.xml"));
        localSearchSolverScope.setWorkingSolution((Solution)examination);
        WorkingMemory workingMemory = localSearchSolverScope.getWorkingMemory();
        localSearchSolverScope.calculateScoreFromWorkingMemory();
        Exam exam = this.findExamById(examination, 123L);
        Room room = this.findRoomById(examination, 0L);
        ExaminationMoveHelper.moveRoom((WorkingMemory)workingMemory, (Exam)exam, (Room)room);
        Score score = localSearchSolverScope.calculateScoreFromWorkingMemory();
        localSearchSolverScope.assertWorkingScore(score);
    }

    private RuleBase buildRuleBase() {
        PackageBuilder packageBuilder = new PackageBuilder();
        InputStream scoreDrlIn = this.getClass().getResourceAsStream("/org/drools/planner/examples/examination/solver/examinationScoreRules.drl");
        try {
            packageBuilder.addPackageFromDrl((Reader)new InputStreamReader(scoreDrlIn, "utf-8"));
        }
        catch (DroolsParserException e) {
            throw new IllegalArgumentException("scoreDrl could not be loaded.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("scoreDrl could not be loaded.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)scoreDrlIn);
        }
        RuleBaseConfiguration ruleBaseConfiguration = new RuleBaseConfiguration();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)ruleBaseConfiguration);
        if (packageBuilder.hasErrors()) {
            throw new IllegalStateException("There are errors in the scoreDrl:" + packageBuilder.getErrors().toString());
        }
        ruleBase.addPackage(packageBuilder.getPackage());
        return ruleBase;
    }

    private Exam findExamById(Examination examination, long id) {
        for (Exam exam : examination.getExamList()) {
            if (exam.getId() != id) continue;
            return exam;
        }
        throw new IllegalArgumentException("Invalid id (" + id + ")");
    }

    private Room findRoomById(Examination examination, long id) {
        for (Room room : examination.getRoomList()) {
            if (room.getId() != id) continue;
            return room;
        }
        throw new IllegalArgumentException("Invalid id (" + id + ")");
    }
}

