/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.solver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.calculator.DefaultHardAndSoftConstraintScoreCalculator;
import org.drools.planner.core.score.calculator.ScoreCalculator;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.app.LoggingTest;
import org.drools.planner.examples.nurserostering.domain.Assignment;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.NurseRoster;
import org.drools.planner.examples.nurserostering.persistence.NurseRosteringDaoImpl;
import org.drools.planner.examples.nurserostering.solver.move.NurseRosteringMoveHelper;
import org.junit.Assert;
import org.junit.Test;

public class NurseRosteringScoreRulesTest
extends LoggingTest {
    @Test
    public void switchEmployeeAndUndo() {
        LocalSearchSolverScope localSearchSolverScope = new LocalSearchSolverScope();
        localSearchSolverScope.setRuleBase(this.buildRuleBase());
        localSearchSolverScope.setWorkingScoreCalculator((ScoreCalculator)new DefaultHardAndSoftConstraintScoreCalculator());
        NurseRoster nurseRoster = (NurseRoster)new NurseRosteringDaoImpl().readSolution(this.getClass().getResourceAsStream("/org/drools/planner/examples/nurserostering/data/testNurseRosteringScoreRules.xml"));
        localSearchSolverScope.setWorkingSolution((Solution)nurseRoster);
        WorkingMemory workingMemory = localSearchSolverScope.getWorkingMemory();
        Score firstScore = localSearchSolverScope.calculateScoreFromWorkingMemory();
        Employee leftEmployee = this.findEmployeeById(nurseRoster, 0L);
        Assignment leftAssignment = this.findAssignmentById(nurseRoster, 200204001L);
        Assert.assertEquals((Object)leftEmployee, (Object)leftAssignment.getEmployee());
        Employee rightEmployee = this.findEmployeeById(nurseRoster, 12L);
        Assignment rightAssignment = this.findAssignmentById(nurseRoster, 200204002L);
        Assert.assertEquals((Object)rightEmployee, (Object)rightAssignment.getEmployee());
        NurseRosteringMoveHelper.moveEmployee((WorkingMemory)workingMemory, (Assignment)leftAssignment, (Employee)rightEmployee);
        NurseRosteringMoveHelper.moveEmployee((WorkingMemory)workingMemory, (Assignment)rightAssignment, (Employee)leftEmployee);
        localSearchSolverScope.calculateScoreFromWorkingMemory();
        NurseRosteringMoveHelper.moveEmployee((WorkingMemory)workingMemory, (Assignment)rightAssignment, (Employee)rightEmployee);
        NurseRosteringMoveHelper.moveEmployee((WorkingMemory)workingMemory, (Assignment)leftAssignment, (Employee)leftEmployee);
        Score secondScore = localSearchSolverScope.calculateScoreFromWorkingMemory();
        Assert.assertEquals((Object)firstScore, (Object)secondScore);
    }

    private RuleBase buildRuleBase() {
        PackageBuilder packageBuilder = new PackageBuilder();
        InputStream scoreDrlIn = this.getClass().getResourceAsStream("/org/drools/planner/examples/nurserostering/solver/nurseRosteringScoreRules.drl");
        try {
            packageBuilder.addPackageFromDrl((Reader)new InputStreamReader(scoreDrlIn, "utf-8"));
        }
        catch (DroolsParserException e) {
            throw new IllegalArgumentException("scoreDrl could not be loaded.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("scoreDrl could not be loaded.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)scoreDrlIn);
        }
        RuleBaseConfiguration ruleBaseConfiguration = new RuleBaseConfiguration();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)ruleBaseConfiguration);
        if (packageBuilder.hasErrors()) {
            throw new IllegalStateException("There are errors in the scoreDrl:" + packageBuilder.getErrors().toString());
        }
        ruleBase.addPackage(packageBuilder.getPackage());
        return ruleBase;
    }

    private Employee findEmployeeById(NurseRoster nurseRoster, long id) {
        for (Employee employee : nurseRoster.getEmployeeList()) {
            if (employee.getId() != id) continue;
            return employee;
        }
        throw new IllegalArgumentException("Invalid id (" + id + ")");
    }

    private Assignment findAssignmentById(NurseRoster nurseRoster, long id) {
        for (Assignment assignment : nurseRoster.getAssignmentList()) {
            if (assignment.getId() != id) continue;
            return assignment;
        }
        throw new IllegalArgumentException("Invalid id (" + id + ")");
    }
}

