/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.examples.tsp.domain.CityAssignment;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;
import org.drools.planner.examples.tsp.solver.move.SubTourChangeMove;
import org.drools.planner.examples.tsp.swingui.TspPanel;

public class TspListPanel
extends JPanel {
    private static final Color HEADER_COLOR = Color.YELLOW;
    private final TspPanel tspPanel;

    public TspListPanel(TspPanel tspPanel) {
        this.tspPanel = tspPanel;
        this.setLayout(new GridLayout(0, 1));
    }

    public void resetPanel() {
        this.removeAll();
        TravelingSalesmanTour travelingSalesmanTour = this.tspPanel.getTravelingSalesmanTour();
        JLabel headerLabel = new JLabel("Tour of " + travelingSalesmanTour.getName());
        headerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        headerLabel.setBackground(HEADER_COLOR);
        headerLabel.setOpaque(true);
        this.add(headerLabel);
        if (travelingSalesmanTour.isInitialized()) {
            for (CityAssignment cityAssignment : travelingSalesmanTour.getCityAssignmentList()) {
                JPanel cityAssignmentPanel = new JPanel(new GridLayout(1, 2));
                JButton button = new JButton(new CityAssignmentAction(cityAssignment));
                cityAssignmentPanel.add(button);
                JLabel distanceLabel = new JLabel("Distance to next: " + cityAssignment.getDistanceToNextCityAssignment());
                cityAssignmentPanel.add(distanceLabel);
                this.add(cityAssignmentPanel);
            }
        }
    }

    private class CityAssignmentAction
    extends AbstractAction {
        private CityAssignment cityAssignment;

        public CityAssignmentAction(CityAssignment cityAssignment) {
            super(cityAssignment.getCity().toString());
            this.cityAssignment = cityAssignment;
        }

        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(2, 1));
            List<CityAssignment> afterCityAssignmentList = TspListPanel.this.tspPanel.getTravelingSalesmanTour().getCityAssignmentList();
            JComboBox<Object> afterCityAssignmentListField = new JComboBox<Object>(afterCityAssignmentList.toArray());
            afterCityAssignmentListField.setSelectedItem(this.cityAssignment.getNextCityAssignment());
            listFieldsPanel.add(afterCityAssignmentListField);
            int result = JOptionPane.showConfirmDialog(TspListPanel.this.getRootPane(), listFieldsPanel, "Select to move after city", 2);
            if (result == 0) {
                CityAssignment toAfterCityAssignment = (CityAssignment)afterCityAssignmentListField.getSelectedItem();
                TspListPanel.this.tspPanel.doMove(new SubTourChangeMove(this.cityAssignment, this.cityAssignment, toAfterCityAssignment));
                TspListPanel.this.tspPanel.getWorkflowFrame().updateScreen();
            }
        }
    }
}

