/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.app;

import java.io.File;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.XmlSolverConfigurer;
import org.drools.planner.config.termination.TerminationConfig;
import org.drools.planner.core.Solver;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.app.LoggingTest;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.junit.Assert;

public abstract class SolverPerformanceTest
extends LoggingTest {
    protected abstract String createSolverConfigResource();

    protected abstract SolutionDao createSolutionDao();

    protected void runSpeedTest(File unsolvedDataFile, String scoreAttainedString) {
        this.runSpeedTest(unsolvedDataFile, scoreAttainedString, EnvironmentMode.PRODUCTION);
    }

    protected void runSpeedTest(File unsolvedDataFile, String scoreAttainedString, EnvironmentMode environmentMode) {
        XmlSolverConfigurer configurer = this.buildConfigurer(scoreAttainedString, environmentMode);
        Solver solver = this.solve(configurer, unsolvedDataFile);
        this.assertBestSolution(solver, scoreAttainedString);
    }

    private XmlSolverConfigurer buildConfigurer(String scoreAttainedString, EnvironmentMode environmentMode) {
        XmlSolverConfigurer configurer = new XmlSolverConfigurer();
        configurer.configure(this.createSolverConfigResource());
        configurer.getSolverConfig().setEnvironmentMode(environmentMode);
        TerminationConfig terminationConfig = new TerminationConfig();
        terminationConfig.setScoreAttained(scoreAttainedString);
        configurer.getSolverConfig().setTerminationConfig(terminationConfig);
        return configurer;
    }

    private Solver solve(XmlSolverConfigurer configurer, File unsolvedDataFile) {
        SolutionDao solutionDao = this.createSolutionDao();
        Solution planningProblem = solutionDao.readSolution(unsolvedDataFile);
        Solver solver = configurer.buildSolver();
        solver.setPlanningProblem(planningProblem);
        solver.solve();
        return solver;
    }

    private void assertBestSolution(Solver solver, String scoreAttainedString) {
        Solution bestSolution = solver.getBestSolution();
        Assert.assertNotNull((Object)bestSolution);
        Score bestScore = bestSolution.getScore();
        Score scoreAttained = solver.getScoreDefinition().parseScore(scoreAttainedString);
        Assert.assertTrue((String)("The bestScore (" + bestScore + ") must be at least scoreAttained (" + scoreAttained + ")."), (bestScore.compareTo((Object)scoreAttained) >= 0 ? 1 : 0) != 0);
    }
}

