/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.domain;

import java.util.EnumSet;
import org.drools.planner.examples.nurserostering.domain.DayOfWeek;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WeekendDefinition {
    SATURDAY_SUNDAY("SaturdaySunday", DayOfWeek.SATURDAY, DayOfWeek.SUNDAY),
    FRIDAY_SATURDAY_SUNDAY("FridaySaturdaySunday", DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY),
    FRIDAY_SATURDAY_SUNDAY_MONDAY("FridaySaturdaySundayMonday", DayOfWeek.FRIDAY, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY, DayOfWeek.MONDAY),
    SATURDAY_SUNDAY_MONDAY("SaturdaySundayMonday", DayOfWeek.SATURDAY, DayOfWeek.SUNDAY, DayOfWeek.MONDAY);

    private EnumSet<DayOfWeek> dayOfWeekSet;
    private DayOfWeek firstDayOfWeekend;
    private DayOfWeek lastDayOfWeekend;
    private String code;

    public static WeekendDefinition valueOfCode(String code) {
        for (WeekendDefinition weekendDefinition : WeekendDefinition.values()) {
            if (!code.equalsIgnoreCase(weekendDefinition.getCode())) continue;
            return weekendDefinition;
        }
        return null;
    }

    private WeekendDefinition(String code, DayOfWeek dayOfWeekend1, DayOfWeek dayOfWeekend2) {
        this.code = code;
        this.dayOfWeekSet = EnumSet.of(dayOfWeekend1, dayOfWeekend2);
        this.firstDayOfWeekend = dayOfWeekend1;
        this.lastDayOfWeekend = dayOfWeekend2;
    }

    private WeekendDefinition(String code, DayOfWeek dayOfWeekend1, DayOfWeek dayOfWeekend2, DayOfWeek dayOfWeekend3) {
        this.code = code;
        this.dayOfWeekSet = EnumSet.of(dayOfWeekend1, dayOfWeekend2, dayOfWeekend3);
        this.firstDayOfWeekend = dayOfWeekend1;
        this.lastDayOfWeekend = dayOfWeekend3;
    }

    private WeekendDefinition(String code, DayOfWeek dayOfWeekend1, DayOfWeek dayOfWeekend2, DayOfWeek dayOfWeekend3, DayOfWeek dayOfWeekend4) {
        this.code = code;
        this.dayOfWeekSet = EnumSet.of(dayOfWeekend1, dayOfWeekend2, dayOfWeekend3, dayOfWeekend4);
        this.firstDayOfWeekend = dayOfWeekend1;
        this.lastDayOfWeekend = dayOfWeekend4;
    }

    public String getCode() {
        return this.code;
    }

    public DayOfWeek getFirstDayOfWeekend() {
        return this.firstDayOfWeekend;
    }

    public DayOfWeek getLastDayOfWeekend() {
        return this.lastDayOfWeekend;
    }

    public String toString() {
        return this.code;
    }

    public boolean isWeekend(DayOfWeek dayOfWeek) {
        return this.dayOfWeekSet.contains((Object)dayOfWeek);
    }

    public int getWeekendLength() {
        return this.dayOfWeekSet.size();
    }
}

