/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.app;

import org.drools.planner.core.Solver;
import org.drools.planner.examples.common.app.LoggingMain;
import org.drools.planner.examples.common.business.SolutionBusiness;
import org.drools.planner.examples.common.persistence.AbstractSolutionExporter;
import org.drools.planner.examples.common.persistence.AbstractSolutionImporter;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.common.swingui.SolverAndPersistenceFrame;

public abstract class CommonApp
extends LoggingMain {
    private SolverAndPersistenceFrame solverAndPersistenceFrame;
    private SolutionBusiness solutionBusiness = this.createSolutionBusiness();

    public CommonApp() {
        this.solverAndPersistenceFrame = new SolverAndPersistenceFrame(this.solutionBusiness, this.createSolutionPanel(), this.solutionBusiness.getDirName());
    }

    public void init() {
        this.init(true);
    }

    public void init(boolean exitOnClose) {
        this.solverAndPersistenceFrame.setDefaultCloseOperation(exitOnClose ? 3 : 2);
        this.solverAndPersistenceFrame.init();
        this.solverAndPersistenceFrame.setVisible(true);
    }

    public SolutionBusiness createSolutionBusiness() {
        SolutionDao solutionDao = this.createSolutionDao();
        SolutionBusiness solutionBusiness = new SolutionBusiness();
        solutionBusiness.setSolutionDao(solutionDao);
        solutionBusiness.setImporter(this.createSolutionImporter());
        solutionBusiness.setExporter(this.createSolutionExporter());
        solutionBusiness.updateDataDirs();
        solutionBusiness.setSolver(this.createSolver());
        return solutionBusiness;
    }

    protected abstract Solver createSolver();

    protected abstract SolutionPanel createSolutionPanel();

    protected abstract SolutionDao createSolutionDao();

    protected AbstractSolutionImporter createSolutionImporter() {
        return null;
    }

    protected AbstractSolutionExporter createSolutionExporter() {
        return null;
    }
}

