/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.domain.solution;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.api.domain.variable.PlanningValueStrengthWeightFactory;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.nqueens.domain.NQueens;
import org.drools.planner.examples.nqueens.domain.Row;

public class RowStrengthWeightFactory
implements PlanningValueStrengthWeightFactory {
    public Comparable createStrengthWeight(Solution solution, Object planningValue) {
        NQueens nQueens = (NQueens)solution;
        Row row = (Row)planningValue;
        int distanceFromMiddle = RowStrengthWeightFactory.calculateDistanceFromMiddle(nQueens.getN(), row.getIndex());
        return new RowStrengthWeight(row, distanceFromMiddle);
    }

    private static int calculateDistanceFromMiddle(int n, int columnIndex) {
        int middle = n / 2;
        int distanceFromMiddle = Math.abs(columnIndex - middle);
        if (n % 2 == 0 && columnIndex < middle) {
            --distanceFromMiddle;
        }
        return distanceFromMiddle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RowStrengthWeight
    implements Comparable<RowStrengthWeight> {
        private final Row row;
        private final int distanceFromMiddle;

        public RowStrengthWeight(Row row, int distanceFromMiddle) {
            this.row = row;
            this.distanceFromMiddle = distanceFromMiddle;
        }

        @Override
        public int compareTo(RowStrengthWeight other) {
            return new CompareToBuilder().append(other.distanceFromMiddle, this.distanceFromMiddle).append(this.row.getIndex(), other.row.getIndex()).toComparison();
        }
    }
}

