/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.traindesign.persistence;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.drools.planner.examples.traindesign.domain.CarBlock;
import org.drools.planner.examples.traindesign.domain.CarBlockDesignation;
import org.drools.planner.examples.traindesign.domain.CrewSegment;
import org.drools.planner.examples.traindesign.domain.RailArc;
import org.drools.planner.examples.traindesign.domain.RailNode;
import org.drools.planner.examples.traindesign.domain.TrainDesign;
import org.drools.planner.examples.traindesign.domain.TrainDesignParametrization;
import org.drools.planner.examples.traindesign.domain.solver.RailPath;
import org.drools.planner.examples.traindesign.persistence.TrainDesignDaoImpl;

public class TrainDesignSolutionImporter
extends AbstractTxtSolutionImporter {
    private static final String INPUT_FILE_SUFFIX = ".csv";
    private static final BigDecimal DISTANCE_MULTIPLICAND = new BigDecimal(1000);

    public static void main(String[] args) {
        new TrainDesignSolutionImporter().convertAll();
    }

    public TrainDesignSolutionImporter() {
        super(new TrainDesignDaoImpl());
    }

    protected String getInputFileSuffix() {
        return INPUT_FILE_SUFFIX;
    }

    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new TrainDesignInputBuilder();
    }

    public class TrainDesignInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private TrainDesign trainDesign;
        private Map<String, RailNode> nameToRailNodeMap = null;

        public Solution readSolution() throws IOException {
            this.trainDesign = new TrainDesign();
            this.trainDesign.setId(0L);
            this.readRailNodeList();
            this.readCarBlockList();
            this.readRailArcList();
            this.readCrewSegmentList();
            this.readTrainDesignParametrization();
            this.trainDesign.initializeTransientProperties();
            this.removeUnavailableRailArcs();
            this.createCarBlockDesignationList();
            TrainDesignSolutionImporter.this.logger.info("TrainDesign with {} rail nodes, {} rail arcs, {} car blocks, {} crew segments.", new Object[]{this.trainDesign.getRailNodeList().size(), this.trainDesign.getRailArcList().size(), this.trainDesign.getCarBlockList().size(), this.trainDesign.getCrewSegmentList().size()});
            return this.trainDesign;
        }

        private void removeUnavailableRailArcs() {
            ArrayList<RailArc> unavailableRailArcList = new ArrayList<RailArc>(this.trainDesign.getRailArcList());
            for (CrewSegment crewSegment : this.trainDesign.getCrewSegmentList()) {
                for (RailPath railPath : crewSegment.getHomeAwayShortestPath().getRailPathList()) {
                    unavailableRailArcList.removeAll(railPath.getRailArcList());
                }
                for (RailPath railPath : crewSegment.getAwayHomeShortestPath().getRailPathList()) {
                    unavailableRailArcList.removeAll(railPath.getRailArcList());
                }
            }
            if (!unavailableRailArcList.isEmpty()) {
                TrainDesignSolutionImporter.this.logger.warn("There are unavailable railArcs (" + unavailableRailArcList + "): removing them.");
                this.trainDesign.getRailArcList().removeAll(unavailableRailArcList);
                for (RailNode railNode : this.trainDesign.getRailNodeList()) {
                    railNode.getOriginatingRailArcList().removeAll(unavailableRailArcList);
                }
                this.trainDesign.initializeTransientProperties();
            }
        }

        private void readRailNodeList() throws IOException {
            this.readConstantLine("\"Network Nodes\";;;;;;");
            this.readConstantLine("\"Node\";\"BlockSwap Cost\";;;;;");
            ArrayList<RailNode> railNodeList = new ArrayList<RailNode>();
            this.nameToRailNodeMap = new HashMap<String, RailNode>();
            String line = this.bufferedReader.readLine();
            long id = 0L;
            while (!line.equals(";;;;;;")) {
                String[] lineTokens = this.splitBySemicolonSeparatedValue(line, 2);
                RailNode railNode = new RailNode();
                railNode.setId(id);
                ++id;
                railNode.setCode(lineTokens[0]);
                railNode.setBlockSwapCost(Integer.parseInt(lineTokens[1]));
                railNode.setOriginatingRailArcList(new ArrayList<RailArc>());
                railNodeList.add(railNode);
                this.nameToRailNodeMap.put(railNode.getCode(), railNode);
                line = this.bufferedReader.readLine();
            }
            this.trainDesign.setRailNodeList(railNodeList);
        }

        private void readCarBlockList() throws IOException {
            this.readConstantLine("\"Blocks\";;;;;;");
            this.readConstantLine("\"BlockID\";\"Origin\";\"Destination\";\"# of Cars\";\"Total Length (Feet)\";\"Total Tonnage (Tons)\";\"Shortest Distance (Miles)\"");
            ArrayList<CarBlock> carBlockList = new ArrayList<CarBlock>();
            String line = this.bufferedReader.readLine();
            long id = 0L;
            while (!line.equals(";;;;;;")) {
                String[] lineTokens = this.splitBySemicolonSeparatedValue(line, 7);
                CarBlock carBlock = new CarBlock();
                carBlock.setId(id);
                ++id;
                carBlock.setCode(lineTokens[0]);
                RailNode origin = this.nameToRailNodeMap.get(lineTokens[1]);
                if (origin == null) {
                    throw new IllegalArgumentException("Read line (" + line + ") has a non existing origin (" + lineTokens[1] + ").");
                }
                carBlock.setOrigin(origin);
                RailNode destination = this.nameToRailNodeMap.get(lineTokens[2]);
                if (destination == null) {
                    throw new IllegalArgumentException("Read line (" + line + ") has a non existing destination (" + lineTokens[2] + ").");
                }
                carBlock.setDestination(destination);
                carBlock.setNumberOfCars(Integer.parseInt(lineTokens[3]));
                carBlock.setLength(Integer.parseInt(lineTokens[4]));
                carBlock.setTonnage(Integer.parseInt(lineTokens[5]));
                carBlock.setShortestDistance(this.readDistance(lineTokens[6]));
                carBlockList.add(carBlock);
                line = this.bufferedReader.readLine();
            }
            this.trainDesign.setCarBlockList(carBlockList);
        }

        private void readRailArcList() throws IOException {
            this.readConstantLine("\"Network\";;;;;;");
            this.readConstantLine("\"Origin\";\"Destination\";\"Distance\";\"Max Train Length(Feet)\";\"Max Tonnage (Tons)\";\"Max # of Trains\";");
            ArrayList<RailArc> railArcList = new ArrayList<RailArc>();
            String line = this.bufferedReader.readLine();
            long id = 0L;
            while (!line.equals(";;;;;;")) {
                String[] lineTokens = this.splitBySemicolonSeparatedValue(line, 6);
                RailArc railArc = new RailArc();
                RailArc reverseRailArc = new RailArc();
                railArc.setId(id);
                reverseRailArc.setId(++id);
                ++id;
                RailNode origin = this.nameToRailNodeMap.get(lineTokens[0]);
                if (origin == null) {
                    throw new IllegalArgumentException("Read line (" + line + ") has a non existing origin (" + lineTokens[0] + ").");
                }
                railArc.setOrigin(origin);
                origin.getOriginatingRailArcList().add(railArc);
                reverseRailArc.setDestination(origin);
                RailNode destination = this.nameToRailNodeMap.get(lineTokens[1]);
                if (destination == null) {
                    throw new IllegalArgumentException("Read line (" + line + ") has a non existing destination (" + lineTokens[1] + ").");
                }
                railArc.setDestination(destination);
                reverseRailArc.setOrigin(destination);
                destination.getOriginatingRailArcList().add(reverseRailArc);
                int distance = this.readDistance(lineTokens[2]);
                railArc.setDistance(distance);
                reverseRailArc.setDistance(distance);
                int maximumTrainLength = Integer.parseInt(lineTokens[3]);
                railArc.setMaximumTrainLength(maximumTrainLength);
                reverseRailArc.setMaximumTrainLength(maximumTrainLength);
                int maximumTonnage = Integer.parseInt(lineTokens[4]);
                railArc.setMaximumTonnage(maximumTonnage);
                reverseRailArc.setMaximumTonnage(maximumTonnage);
                int maximumNumberOfTrains = Integer.parseInt(lineTokens[5]);
                railArc.setMaximumNumberOfTrains(maximumNumberOfTrains);
                reverseRailArc.setMaximumNumberOfTrains(maximumNumberOfTrains);
                railArc.setReverse(reverseRailArc);
                reverseRailArc.setReverse(railArc);
                railArcList.add(railArc);
                railArcList.add(reverseRailArc);
                line = this.bufferedReader.readLine();
            }
            this.trainDesign.setRailArcList(railArcList);
        }

        private void readCrewSegmentList() throws IOException {
            this.readConstantLine("\"Crew Segments\";;;;;;");
            this.readConstantLine("\"Node1\";\"Node2\";;;;;");
            ArrayList<CrewSegment> crewSegmentList = new ArrayList<CrewSegment>();
            String line = this.bufferedReader.readLine();
            long id = 0L;
            while (!line.equals(";;;;;;")) {
                String[] lineTokens = this.splitBySemicolonSeparatedValue(line, 2);
                CrewSegment crewSegment = new CrewSegment();
                crewSegment.setId(id);
                ++id;
                RailNode home = this.nameToRailNodeMap.get(lineTokens[0]);
                if (home == null) {
                    throw new IllegalArgumentException("Read line (" + line + ") has a non existing crew home (" + lineTokens[0] + ").");
                }
                crewSegment.setHome(home);
                RailNode away = this.nameToRailNodeMap.get(lineTokens[1]);
                if (away == null) {
                    throw new IllegalArgumentException("Read line (" + line + ") has a non existing crew away (" + lineTokens[1] + ").");
                }
                crewSegment.setAway(away);
                crewSegmentList.add(crewSegment);
                line = this.bufferedReader.readLine();
            }
            this.trainDesign.setCrewSegmentList(crewSegmentList);
        }

        private void readTrainDesignParametrization() throws IOException {
            this.readConstantLine("\"Parameters\";;;;;;");
            this.readConstantLine("\"Parameters\";\"Values\";;;;;");
            TrainDesignParametrization trainDesignParametrization = new TrainDesignParametrization();
            trainDesignParametrization.setCrewImbalancePenalty(this.readIntegerValue("\"Crew Imbalance Penalty per imbalance\";", ";;;;;"));
            trainDesignParametrization.setTrainImbalancePenalty(this.readIntegerValue("\"Train Imbalance Penalty per imbalance\";", ";;;;;"));
            trainDesignParametrization.setTrainTravelCostPerDistance(this.readDistance(this.readStringValue("\"Train travel cost per mile\";", ";;;;;")));
            trainDesignParametrization.setCarTravelCostPerDistance(this.readDistance(this.readStringValue("\"Car travel cost per mile\";", ";;;;;")));
            trainDesignParametrization.setWorkEventCost(this.readIntegerValue("\"Cost per work event\";", ";;;;;"));
            trainDesignParametrization.setMaximumBlocksPerTrain(this.readIntegerValue("\"Maximum Blocks per train\";", ";;;;;"));
            trainDesignParametrization.setMaximumBlockSwapsPerBlock(this.readIntegerValue("\"Maximum Block swaps per block\";", ";;;;;"));
            trainDesignParametrization.setMaximumIntermediateWorkEventsPerTrain(this.readIntegerValue("\"Maximum intermediate work events per train\";", ";;;;;"));
            trainDesignParametrization.setTrainStartCost(this.readIntegerValue("\"Train start Cost\";", ";;;;;"));
            trainDesignParametrization.setMissedCarCost(this.readIntegerValue("\"Missed cost per railcar\";", ";;;;;"));
            this.trainDesign.setTrainDesignParametrization(trainDesignParametrization);
        }

        private int readDistance(String lineToken) {
            BigDecimal distanceBigDecimal = new BigDecimal(lineToken).multiply(DISTANCE_MULTIPLICAND);
            if (distanceBigDecimal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0) {
                throw new IllegalArgumentException("The distance (" + lineToken + ") is too detailed.");
            }
            return distanceBigDecimal.intValue();
        }

        private void createCarBlockDesignationList() {
            List<CarBlock> carBlockList = this.trainDesign.getCarBlockList();
            ArrayList<CarBlockDesignation> carBlockDesignationList = new ArrayList<CarBlockDesignation>(carBlockList.size());
            long id = 0L;
            for (CarBlock carBlock : carBlockList) {
                CarBlockDesignation carBlockDesignation = new CarBlockDesignation();
                carBlockDesignation.setId(id);
                ++id;
                carBlockDesignation.setCarBlock(carBlock);
                carBlockDesignationList.add(carBlockDesignation);
            }
            this.trainDesign.setCarBlockDesignationList(carBlockDesignationList);
        }
    }
}

