/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.travelingtournament.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.drools.planner.examples.travelingtournament.domain.Day;
import org.drools.planner.examples.travelingtournament.domain.Match;
import org.drools.planner.examples.travelingtournament.domain.Team;
import org.drools.planner.examples.travelingtournament.domain.TravelingTournament;

public abstract class TravelingTournamentSolutionImporter
extends AbstractTxtSolutionImporter {
    protected TravelingTournamentSolutionImporter(SolutionDao solutionDao) {
        super(solutionDao);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class TravelingTournamentInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        @Override
        public Solution readSolution() throws IOException {
            TravelingTournament travelingTournament = new TravelingTournament();
            travelingTournament.setId(0L);
            int n = this.readN();
            this.readTeamList(travelingTournament, n);
            this.createDayList(travelingTournament, n);
            List<List<Integer>> outerDistanceList = this.readOuterDistanceList(travelingTournament);
            this.createMatchListAndSetDistancesInTeamList(travelingTournament, outerDistanceList);
            this.initializeMatchDays(travelingTournament);
            return travelingTournament;
        }

        private int readN() throws IOException {
            return Integer.parseInt(this.bufferedReader.readLine());
        }

        private void readTeamList(TravelingTournament travelingTournament, int n) throws IOException {
            ArrayList<Team> teamList = new ArrayList<Team>();
            for (int i = 0; i < n; ++i) {
                Team team = new Team();
                team.setId(Long.valueOf(i));
                team.setName(this.bufferedReader.readLine());
                team.setDistanceToTeamMap(new HashMap<Team, Integer>());
                teamList.add(team);
            }
            travelingTournament.setTeamList(teamList);
        }

        private List<List<Integer>> readOuterDistanceList(TravelingTournament travelingTournament) throws IOException {
            ArrayList<List<Integer>> outerDistanceList = new ArrayList<List<Integer>>();
            String line = this.bufferedReader.readLine();
            while (line != null && !line.replaceAll("\\s+", "").equals("")) {
                StringTokenizer tokenizer = new StringTokenizer(line.replaceAll("\\s+", " ").trim());
                ArrayList<Integer> innerDistanceList = new ArrayList<Integer>();
                while (tokenizer.hasMoreTokens()) {
                    int distance = Integer.parseInt(tokenizer.nextToken());
                    innerDistanceList.add(distance);
                }
                outerDistanceList.add(innerDistanceList);
                line = this.bufferedReader.readLine();
            }
            return outerDistanceList;
        }

        private void createDayList(TravelingTournament travelingTournament, int n) {
            ArrayList<Day> dayList = new ArrayList<Day>();
            int daySize = (n - 1) * 2;
            Day previousDay = null;
            for (int i = 0; i < daySize; ++i) {
                Day day = new Day();
                day.setId(Long.valueOf(i));
                day.setIndex(i);
                dayList.add(day);
                if (previousDay != null) {
                    previousDay.setNextDay(day);
                }
                previousDay = day;
            }
            travelingTournament.setDayList(dayList);
        }

        private void createMatchListAndSetDistancesInTeamList(TravelingTournament travelingTournament, List<List<Integer>> outerDistanceList) {
            List<Team> teamList = travelingTournament.getTeamList();
            ArrayList<Match> matchList = new ArrayList<Match>();
            int i = 0;
            long matchId = 0L;
            for (Team homeTeam : teamList) {
                int j = 0;
                for (Team awayTeam : teamList) {
                    int distance = outerDistanceList.get(i).get(j);
                    homeTeam.getDistanceToTeamMap().put(awayTeam, distance);
                    if (i != j) {
                        Match match = new Match();
                        match.setId(matchId);
                        ++matchId;
                        match.setHomeTeam(homeTeam);
                        match.setAwayTeam(awayTeam);
                        matchList.add(match);
                    }
                    ++j;
                }
                ++i;
            }
            travelingTournament.setMatchList(matchList);
        }

        protected abstract void initializeMatchDays(TravelingTournament var1);
    }
}

