/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.tsp.domain.CityAssignment;
import org.drools.planner.examples.tsp.solver.move.TspMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubTourChangeMove
implements Move,
TabuPropertyEnabled {
    private CityAssignment startCityAssignment;
    private CityAssignment endCityAssignment;
    private CityAssignment toAfterCityAssignment;

    public SubTourChangeMove(CityAssignment startCityAssignment, CityAssignment endCityAssignment, CityAssignment toAfterCityAssignment) {
        this.startCityAssignment = startCityAssignment;
        this.endCityAssignment = endCityAssignment;
        this.toAfterCityAssignment = toAfterCityAssignment;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        CityAssignment nextCityAssignment = this.startCityAssignment;
        if (ObjectUtils.equals((Object)this.startCityAssignment, (Object)this.toAfterCityAssignment.getNextCityAssignment())) {
            return false;
        }
        while (!ObjectUtils.equals((Object)nextCityAssignment, (Object)this.endCityAssignment)) {
            if (ObjectUtils.equals((Object)nextCityAssignment, (Object)this.toAfterCityAssignment)) {
                return false;
            }
            nextCityAssignment = nextCityAssignment.getNextCityAssignment();
        }
        return !ObjectUtils.equals((Object)this.endCityAssignment, (Object)this.toAfterCityAssignment);
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new SubTourChangeMove(this.startCityAssignment, this.endCityAssignment, this.startCityAssignment.getPreviousCityAssignment());
    }

    public void doMove(WorkingMemory workingMemory) {
        CityAssignment newPreviousCityAssignment = this.toAfterCityAssignment;
        CityAssignment newNextCityAssignment = newPreviousCityAssignment.getNextCityAssignment();
        CityAssignment originalPreviousCityAssignment = this.startCityAssignment.getPreviousCityAssignment();
        CityAssignment originalNextCityAssignment = this.endCityAssignment.getNextCityAssignment();
        TspMoveHelper.moveCityAssignmentAfterCityAssignment(workingMemory, newPreviousCityAssignment, this.startCityAssignment);
        TspMoveHelper.moveCityAssignmentAfterCityAssignment(workingMemory, this.endCityAssignment, newNextCityAssignment);
        TspMoveHelper.moveCityAssignmentAfterCityAssignment(workingMemory, originalPreviousCityAssignment, originalNextCityAssignment);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.startCityAssignment.getCity());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubTourChangeMove) {
            SubTourChangeMove other = (SubTourChangeMove)o;
            return new EqualsBuilder().append((Object)this.startCityAssignment, (Object)other.startCityAssignment).append((Object)this.endCityAssignment, (Object)other.endCityAssignment).append((Object)this.toAfterCityAssignment, (Object)other.toAfterCityAssignment).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.startCityAssignment).append((Object)this.endCityAssignment).append((Object)this.toAfterCityAssignment).toHashCode();
    }

    public String toString() {
        return this.startCityAssignment + "-" + this.endCityAssignment + " => after " + this.toAfterCityAssignment;
    }
}

