/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.persistence;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Random;
import org.drools.planner.examples.cloudbalancing.domain.CloudBalance;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.cloudbalancing.persistence.CloudBalancingDaoImpl;
import org.drools.planner.examples.common.app.LoggingMain;
import org.drools.planner.examples.common.persistence.SolutionDao;

public class CloudBalancingGenerator
extends LoggingMain {
    private static final Price[] CPU_POWER_PRICES = new Price[]{new Price(3, "single core 3ghz", 110), new Price(4, "dual core 2ghz", 140), new Price(6, "dual core 3ghz", 180), new Price(8, "quad core 2ghz", 270), new Price(12, "quad core 3ghz", 400), new Price(16, "quad core 4ghz", 1000), new Price(24, "eight core 3ghz", 3000)};
    private static final Price[] MEMORY_PRICES = new Price[]{new Price(2, "2 gigabyte", 140), new Price(4, "4 gigabyte", 180), new Price(8, "8 gigabyte", 220), new Price(16, "16 gigabyte", 300), new Price(32, "32 gigabyte", 400), new Price(64, "64 gigabyte", 600), new Price(96, "96 gigabyte", 1000)};
    private static final Price[] NETWORK_BANDWIDTH_PRICES = new Price[]{new Price(2, "2 gigabyte", 100), new Price(4, "4 gigabyte", 200), new Price(6, "6 gigabyte", 300), new Price(8, "8 gigabyte", 400), new Price(12, "12 gigabyte", 600), new Price(16, "16 gigabyte", 800), new Price(20, "20 gigabyte", 1000)};
    private static final int MAXIMUM_REQUIRED_CPU_POWER = 12;
    private static final int MAXIMUM_REQUIRED_MEMORY = 32;
    private static final int MAXIMUM_REQUIRED_NETWORK_BANDWIDTH = 12;
    private static final File outputDir = new File("data/cloudbalancing/unsolved/");
    protected SolutionDao solutionDao;
    private Random random;

    public static void main(String[] args) {
        new CloudBalancingGenerator().generate();
    }

    public CloudBalancingGenerator() {
        this.checkConfiguration();
        this.solutionDao = new CloudBalancingDaoImpl();
    }

    public void generate() {
        this.writeCloudBalance(2, 6);
        this.writeCloudBalance(3, 9);
        this.writeCloudBalance(4, 12);
        this.writeCloudBalance(100, 300);
        this.writeCloudBalance(200, 600);
        this.writeCloudBalance(400, 1200);
        this.writeCloudBalance(800, 2400);
    }

    private void checkConfiguration() {
        if (CPU_POWER_PRICES.length != MEMORY_PRICES.length || CPU_POWER_PRICES.length != NETWORK_BANDWIDTH_PRICES.length) {
            throw new IllegalStateException("All price arrays must be equal in length.");
        }
    }

    private void writeCloudBalance(int cloudComputerListSize, int cloudProcessListSize) {
        File outputFile = this.determineOutputFile(cloudComputerListSize, cloudProcessListSize);
        CloudBalance cloudBalance = this.createCloudBalance(cloudComputerListSize, cloudProcessListSize);
        this.solutionDao.writeSolution(cloudBalance, outputFile);
    }

    private File determineOutputFile(int cloudComputerListSize, int cloudProcessListSize) {
        String cloudProcessListSizeString;
        String cloudComputerListSizeString = Integer.toString(cloudComputerListSize);
        if (cloudComputerListSizeString.length() < 4) {
            cloudComputerListSizeString = "0000".substring(0, 4 - cloudComputerListSizeString.length()) + cloudComputerListSizeString;
        }
        if ((cloudProcessListSizeString = Integer.toString(cloudProcessListSize)).length() < 4) {
            cloudProcessListSizeString = "0000".substring(0, 4 - cloudProcessListSizeString.length()) + cloudProcessListSizeString;
        }
        String outputFileName = "cb-" + cloudComputerListSizeString + "comp-" + cloudProcessListSizeString + "proc.xml";
        return new File(outputDir, outputFileName);
    }

    private CloudBalance createCloudBalance(int cloudComputerListSize, int cloudProcessListSize) {
        this.random = new Random(47L);
        CloudBalance cloudBalance = new CloudBalance();
        cloudBalance.setId(0L);
        this.createCloudComputerList(cloudBalance, cloudComputerListSize);
        this.createCloudProcessList(cloudBalance, cloudProcessListSize);
        this.logger.info("CloudBalance {} with {} computers and {} processes.", (Object)cloudBalance.getCloudComputerList().size(), (Object)cloudBalance.getCloudProcessList().size());
        BigInteger possibleSolutionSize = BigInteger.valueOf(cloudBalance.getCloudComputerList().size()).pow(cloudBalance.getCloudProcessList().size());
        String flooredPossibleSolutionSize = "10^" + (possibleSolutionSize.toString().length() - 1);
        this.logger.info("CloudBalance with flooredPossibleSolutionSize ({}) and possibleSolutionSize ({}).", (Object)flooredPossibleSolutionSize, (Object)possibleSolutionSize);
        return cloudBalance;
    }

    private void createCloudComputerList(CloudBalance cloudBalance, int cloudComputerListSize) {
        ArrayList<CloudComputer> cloudComputerList = new ArrayList<CloudComputer>(cloudComputerListSize);
        for (int i = 0; i < cloudComputerListSize; ++i) {
            CloudComputer cloudComputer = new CloudComputer();
            cloudComputer.setId(Long.valueOf(i));
            int cpuPowerPricesIndex = this.random.nextInt(CPU_POWER_PRICES.length);
            cloudComputer.setCpuPower(CPU_POWER_PRICES[cpuPowerPricesIndex].getHardwareValue());
            int memoryPricesIndex = this.distortIndex(cpuPowerPricesIndex, MEMORY_PRICES.length);
            cloudComputer.setMemory(MEMORY_PRICES[memoryPricesIndex].getHardwareValue());
            int networkBandwidthPricesIndex = this.distortIndex(cpuPowerPricesIndex, NETWORK_BANDWIDTH_PRICES.length);
            cloudComputer.setNetworkBandwidth(NETWORK_BANDWIDTH_PRICES[networkBandwidthPricesIndex].getHardwareValue());
            int cost = CPU_POWER_PRICES[cpuPowerPricesIndex].getCost() + MEMORY_PRICES[memoryPricesIndex].getCost() + NETWORK_BANDWIDTH_PRICES[networkBandwidthPricesIndex].getCost();
            this.logger.debug("Created cloudComputer with cpuPowerPricesIndex ({}), memoryPricesIndex({}), networkBandwidthPricesIndex({}).", new Object[]{cpuPowerPricesIndex, memoryPricesIndex, networkBandwidthPricesIndex});
            cloudComputer.setCost(cost);
            cloudComputerList.add(cloudComputer);
        }
        cloudBalance.setCloudComputerList(cloudComputerList);
    }

    private int distortIndex(int referenceIndex, int length) {
        int index = referenceIndex;
        double randomDouble = this.random.nextDouble();
        for (double loweringThreshold = 0.25; randomDouble < loweringThreshold && index >= 1; --index, loweringThreshold *= 0.1) {
        }
        double heighteningThreshold = 0.75;
        while (randomDouble >= heighteningThreshold && index <= length - 2) {
            ++index;
            heighteningThreshold = 1.0 - (1.0 - heighteningThreshold) * 0.1;
        }
        return index;
    }

    private void createCloudProcessList(CloudBalance cloudBalance, int cloudProcessListSize) {
        ArrayList<CloudProcess> cloudProcessList = new ArrayList<CloudProcess>(cloudProcessListSize);
        for (int i = 0; i < cloudProcessListSize; ++i) {
            CloudProcess cloudProcess = new CloudProcess();
            cloudProcess.setId(Long.valueOf(i));
            int requiredCpuPower = this.generateRandom(12);
            cloudProcess.setRequiredCpuPower(requiredCpuPower);
            int requiredMemory = this.generateRandom(32);
            cloudProcess.setRequiredMemory(requiredMemory);
            int requiredNetworkBandwidth = this.generateRandom(12);
            cloudProcess.setRequiredNetworkBandwidth(requiredNetworkBandwidth);
            this.logger.debug("Created CloudProcess with requiredCpuPower ({}), requiredMemory({}), requiredNetworkBandwidth({}).", new Object[]{requiredCpuPower, requiredMemory, requiredNetworkBandwidth});
            cloudProcessList.add(cloudProcess);
        }
        cloudBalance.setCloudProcessList(cloudProcessList);
    }

    private int generateRandom(int maximumValue) {
        double parabolaBase = 2000.0;
        double randomDouble = this.random.nextDouble();
        double parabolaRandomDouble = (Math.pow(parabolaBase, randomDouble) - 1.0) / (parabolaBase - 1.0);
        if (parabolaRandomDouble < 0.0 || parabolaRandomDouble >= 1.0) {
            throw new IllegalArgumentException("Invalid generated parabolaRandomDouble (" + parabolaRandomDouble + ")");
        }
        int value = (int)Math.floor(parabolaRandomDouble * (double)maximumValue) + 1;
        if (value < 1 || value > maximumValue) {
            throw new IllegalArgumentException("Invalid generated value (" + value + ")");
        }
        return value;
    }

    private static class Price {
        private int hardwareValue;
        private String description;
        private int cost;

        private Price(int hardwareValue, String description, int cost) {
            this.hardwareValue = hardwareValue;
            this.description = description;
            this.cost = cost;
        }

        public int getHardwareValue() {
            return this.hardwareValue;
        }

        public String getDescription() {
            return this.description;
        }

        public int getCost() {
            return this.cost;
        }
    }
}

