/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.solver.move.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.CachedMoveFactory;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.cloudbalancing.domain.CloudBalance;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.cloudbalancing.solver.move.CloudProcessSwitchMove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudProcessSwitchMoveFactory
extends CachedMoveFactory {
    public List<Move> createCachedMoveList(Solution solution) {
        CloudBalance cloudBalance = (CloudBalance)solution;
        List<CloudProcess> cloudProcessList = cloudBalance.getCloudProcessList();
        ArrayList<Move> moveList = new ArrayList<Move>();
        ListIterator<CloudProcess> leftIt = cloudProcessList.listIterator();
        while (leftIt.hasNext()) {
            CloudProcess leftCloudProcess = leftIt.next();
            ListIterator<CloudProcess> rightIt = cloudProcessList.listIterator(leftIt.nextIndex());
            while (rightIt.hasNext()) {
                CloudProcess rightCloudProcess = rightIt.next();
                moveList.add(new CloudProcessSwitchMove(leftCloudProcess, rightCloudProcess));
            }
        }
        return moveList;
    }
}

