/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.cloudbalancing.swingui.CloudBalancingPanel;

public class CloudComputerPanel
extends JPanel {
    private final CloudBalancingPanel cloudBalancingPanel;
    private CloudComputer cloudComputer;
    private List<CloudProcess> cloudProcessList = new ArrayList<CloudProcess>();
    private JLabel computerLabel;
    private JButton deleteButton;
    private JTextField cpuPowerField;
    private JTextField memoryField;
    private JTextField networkBandwidthField;
    private JTextField costField;
    private JLabel numberOfProcessesLabel;
    private CloudBar cpuPowerBar;
    private CloudBar memoryBar;
    private CloudBar networkBandwidthBar;
    private JButton detailsButton;

    public CloudComputerPanel(CloudBalancingPanel cloudBalancingPanel, CloudComputer cloudComputer) {
        super(new GridLayout(0, 5));
        this.cloudBalancingPanel = cloudBalancingPanel;
        this.cloudComputer = cloudComputer;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2), BorderFactory.createLineBorder(Color.BLACK)), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.addTotals();
        this.addBars();
    }

    public CloudComputer getCloudComputer() {
        return this.cloudComputer;
    }

    private String getComputerLabel() {
        return this.cloudComputer == null ? "Unassigned" : this.cloudComputer.getLabel();
    }

    private int getComputerCpuPower() {
        return this.cloudComputer == null ? 0 : this.cloudComputer.getCpuPower();
    }

    private int getComputerMemory() {
        return this.cloudComputer == null ? 0 : this.cloudComputer.getMemory();
    }

    private int getComputerNetworkBandwidth() {
        return this.cloudComputer == null ? 0 : this.cloudComputer.getNetworkBandwidth();
    }

    private int getComputerCost() {
        return this.cloudComputer == null ? 0 : this.cloudComputer.getCost();
    }

    private void addTotals() {
        JPanel labelAndDeletePanel = new JPanel(new BorderLayout());
        this.computerLabel = new JLabel(this.getComputerLabel());
        this.computerLabel.setEnabled(false);
        labelAndDeletePanel.add((Component)this.computerLabel, "Center");
        if (this.cloudComputer != null) {
            this.deleteButton = new JButton(new AbstractAction("X"){

                public void actionPerformed(ActionEvent e) {
                    CloudComputerPanel.this.cloudBalancingPanel.deleteComputer(CloudComputerPanel.this.cloudComputer);
                }
            });
            labelAndDeletePanel.add((Component)this.deleteButton, "East");
        }
        this.add(labelAndDeletePanel);
        this.cpuPowerField = new JTextField("0 GHz / " + this.getComputerCpuPower() + " GHz");
        this.cpuPowerField.setEditable(false);
        this.cpuPowerField.setEnabled(false);
        this.add(this.cpuPowerField);
        this.memoryField = new JTextField("0 GB / " + this.getComputerMemory() + " GB");
        this.memoryField.setEditable(false);
        this.memoryField.setEnabled(false);
        this.add(this.memoryField);
        this.networkBandwidthField = new JTextField("0 GB / " + this.getComputerNetworkBandwidth() + " GB");
        this.networkBandwidthField.setEditable(false);
        this.networkBandwidthField.setEnabled(false);
        this.add(this.networkBandwidthField);
        this.costField = new JTextField(this.getComputerCost() + " $");
        this.costField.setEditable(false);
        this.costField.setEnabled(false);
        this.add(this.costField);
    }

    private void addBars() {
        this.numberOfProcessesLabel = new JLabel("    0 processes");
        this.numberOfProcessesLabel.setEnabled(false);
        this.add(this.numberOfProcessesLabel);
        this.cpuPowerBar = new CloudBar(this.getComputerCpuPower());
        this.cpuPowerBar.setEnabled(false);
        this.add(this.cpuPowerBar);
        this.memoryBar = new CloudBar(this.getComputerMemory());
        this.memoryBar.setEnabled(false);
        this.add(this.memoryBar);
        this.networkBandwidthBar = new CloudBar(this.getComputerNetworkBandwidth());
        this.networkBandwidthBar.setEnabled(false);
        this.add(this.networkBandwidthBar);
        this.detailsButton = new JButton(new AbstractAction("Details"){

            public void actionPerformed(ActionEvent e) {
                CloudProcessListDialog cloudProcessListDialog = new CloudProcessListDialog();
                cloudProcessListDialog.setLocationRelativeTo(CloudComputerPanel.this.getRootPane());
                cloudProcessListDialog.setVisible(true);
            }
        });
        this.detailsButton.setEnabled(false);
        this.add(this.detailsButton);
    }

    public void addCloudProcess(CloudProcess cloudProcess) {
        this.cloudProcessList.add(cloudProcess);
    }

    public void removeCloudProcess(CloudProcess cloudProcess) {
        this.cloudProcessList.remove(cloudProcess);
    }

    public void clearCloudProcesss() {
        this.cloudProcessList.clear();
    }

    public void update() {
        int usedCpuPower = 0;
        this.cpuPowerBar.clearProcessValues();
        int usedMemory = 0;
        this.memoryBar.clearProcessValues();
        int usedNetworkBandwidth = 0;
        this.networkBandwidthBar.clearProcessValues();
        int colorIndex = 0;
        for (CloudProcess cloudProcess : this.cloudProcessList) {
            usedCpuPower += cloudProcess.getRequiredCpuPower();
            this.cpuPowerBar.addProcessValue(cloudProcess.getRequiredCpuPower());
            usedMemory += cloudProcess.getRequiredMemory();
            this.memoryBar.addProcessValue(cloudProcess.getRequiredMemory());
            usedNetworkBandwidth += cloudProcess.getRequiredNetworkBandwidth();
            this.networkBandwidthBar.addProcessValue(cloudProcess.getRequiredNetworkBandwidth());
            colorIndex = (colorIndex + 1) % CloudBalancingPanel.PROCESS_COLORS.length;
        }
        boolean used = this.cloudProcessList.size() > 0;
        this.updateTotals(usedCpuPower, usedMemory, usedNetworkBandwidth, used);
        this.updateBars(used);
    }

    private void updateTotals(int usedCpuPower, int usedMemory, int usedNetworkBandwidth, boolean used) {
        this.computerLabel.setEnabled(used);
        this.cpuPowerField.setText(usedCpuPower + " GHz / " + this.getComputerCpuPower() + " GHz");
        this.cpuPowerField.setForeground(usedCpuPower > this.getComputerCpuPower() ? Color.RED : Color.BLACK);
        this.cpuPowerField.setEnabled(used);
        this.memoryField.setText(usedMemory + " GB / " + this.getComputerMemory() + " GB");
        this.memoryField.setForeground(usedMemory > this.getComputerMemory() ? Color.RED : Color.BLACK);
        this.memoryField.setEnabled(used);
        this.networkBandwidthField.setText(usedNetworkBandwidth + " GB / " + this.getComputerNetworkBandwidth() + " GB");
        this.networkBandwidthField.setForeground(usedNetworkBandwidth > this.getComputerNetworkBandwidth() ? Color.RED : Color.BLACK);
        this.networkBandwidthField.setEnabled(used);
        this.costField.setEnabled(used);
    }

    private void updateBars(boolean used) {
        this.numberOfProcessesLabel.setText("    " + this.cloudProcessList.size() + " processes");
        this.numberOfProcessesLabel.setEnabled(used);
        this.cpuPowerBar.setEnabled(used);
        this.cpuPowerBar.repaint();
        this.memoryBar.setEnabled(used);
        this.memoryBar.repaint();
        this.networkBandwidthBar.setEnabled(used);
        this.networkBandwidthBar.repaint();
        this.detailsButton.setEnabled(used);
    }

    private class CloudProcessListDialog
    extends JDialog {
        public CloudProcessListDialog() {
            this.setModal(true);
            this.setTitle(CloudComputerPanel.this.getComputerLabel());
            JPanel contentPanel = new JPanel();
            GroupLayout layout = new GroupLayout(contentPanel);
            contentPanel.setLayout(layout);
            JPanel headerPanel = this.createHeaderPanel();
            JPanel assignmentsPanel = this.createAssignmentsPanel();
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(assignmentsPanel));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(assignmentsPanel, -2, -2, -2));
            JScrollPane contentScrollPane = new JScrollPane(contentPanel);
            contentScrollPane.setPreferredSize(new Dimension(800, 200));
            contentScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setContentPane(contentScrollPane);
            this.pack();
        }

        private JPanel createHeaderPanel() {
            JPanel headerPanel = new JPanel(new GridLayout(0, 5));
            headerPanel.add(new JLabel(""));
            JLabel cpuPowerLabel = new JLabel("CPU power");
            headerPanel.add(cpuPowerLabel);
            JLabel memoryLabel = new JLabel("Memory");
            headerPanel.add(memoryLabel);
            JLabel networkBandwidthLabel = new JLabel("Network bandwidth");
            headerPanel.add(networkBandwidthLabel);
            headerPanel.add(new JLabel(""));
            return headerPanel;
        }

        private JPanel createAssignmentsPanel() {
            JPanel assignmentsPanel = new JPanel(new GridLayout(0, 5));
            int colorIndex = 0;
            for (CloudProcess cloudProcess : CloudComputerPanel.this.cloudProcessList) {
                JLabel cloudProcessLabel = new JLabel(cloudProcess.getLabel());
                cloudProcessLabel.setForeground(CloudBalancingPanel.PROCESS_COLORS[colorIndex]);
                assignmentsPanel.add(cloudProcessLabel);
                JTextField cpuPowerField = new JTextField(cloudProcess.getRequiredCpuPower() + " GHz");
                cpuPowerField.setEditable(false);
                assignmentsPanel.add(cpuPowerField);
                JTextField memoryField = new JTextField(cloudProcess.getRequiredMemory() + " GB");
                memoryField.setEditable(false);
                assignmentsPanel.add(memoryField);
                JTextField networkBandwidthField = new JTextField(cloudProcess.getRequiredNetworkBandwidth() + " GB");
                networkBandwidthField.setEditable(false);
                assignmentsPanel.add(networkBandwidthField);
                assignmentsPanel.add(new JLabel(""));
                colorIndex = (colorIndex + 1) % CloudBalancingPanel.PROCESS_COLORS.length;
            }
            return assignmentsPanel;
        }
    }

    private static class CloudBar
    extends JPanel {
        private List<Integer> processValues = new ArrayList<Integer>();
        private int computerValue;

        public CloudBar(int computerValue) {
            this.computerValue = computerValue;
        }

        public void clearProcessValues() {
            this.processValues.clear();
        }

        public void addProcessValue(int processValue) {
            this.processValues.add(processValue);
        }

        protected void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            int rectHeight = size.height;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, rectHeight);
            int computerWidth = size.width * 4 / 5;
            computerWidth = Math.max(computerWidth, 1);
            if (this.computerValue > 0) {
                g.setColor(this.isEnabled() ? Color.WHITE : this.getBackground());
                g.fillRect(0, 0, computerWidth, rectHeight);
            }
            int offset = 0;
            int colorIndex = 0;
            int safeComputerValue = this.computerValue;
            if (safeComputerValue <= 0) {
                safeComputerValue = 0;
                for (int processValue : this.processValues) {
                    safeComputerValue += processValue;
                }
            }
            for (int processValue : this.processValues) {
                int processWidth = processValue * computerWidth / safeComputerValue;
                processWidth = Math.max(processWidth, 1);
                g.setColor(CloudBalancingPanel.PROCESS_COLORS[colorIndex]);
                g.fillRect(offset, 0, processWidth, rectHeight);
                offset += processWidth;
                colorIndex = (colorIndex + 1) % CloudBalancingPanel.PROCESS_COLORS.length;
            }
            if (this.computerValue > 0) {
                g.setColor(this.isEnabled() ? Color.BLACK : Color.DARK_GRAY);
                g.drawRect(0, 0, computerWidth, rectHeight - 1);
            }
        }
    }
}

