/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.examination.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScore;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.examination.domain.Exam;
import org.drools.planner.examples.examination.domain.InstitutionalWeighting;
import org.drools.planner.examples.examination.domain.Period;
import org.drools.planner.examples.examination.domain.PeriodHardConstraint;
import org.drools.planner.examples.examination.domain.Room;
import org.drools.planner.examples.examination.domain.RoomHardConstraint;
import org.drools.planner.examples.examination.domain.Student;
import org.drools.planner.examples.examination.domain.Topic;
import org.drools.planner.examples.examination.domain.solver.TopicConflict;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="Examination")
public class Examination
extends AbstractPersistable
implements Solution<HardAndSoftScore> {
    private InstitutionalWeighting institutionalWeighting;
    private List<Student> studentList;
    private List<Topic> topicList;
    private List<Period> periodList;
    private List<Room> roomList;
    private List<PeriodHardConstraint> periodHardConstraintList;
    private List<RoomHardConstraint> roomHardConstraintList;
    private List<Exam> examList;
    private HardAndSoftScore score;

    public InstitutionalWeighting getInstitutionalWeighting() {
        return this.institutionalWeighting;
    }

    public void setInstitutionalWeighting(InstitutionalWeighting institutionalWeighting) {
        this.institutionalWeighting = institutionalWeighting;
    }

    public List<Student> getStudentList() {
        return this.studentList;
    }

    public void setStudentList(List<Student> studentList) {
        this.studentList = studentList;
    }

    public List<Topic> getTopicList() {
        return this.topicList;
    }

    public void setTopicList(List<Topic> topicList) {
        this.topicList = topicList;
    }

    public List<Period> getPeriodList() {
        return this.periodList;
    }

    public void setPeriodList(List<Period> periodList) {
        this.periodList = periodList;
    }

    public List<Room> getRoomList() {
        return this.roomList;
    }

    public void setRoomList(List<Room> roomList) {
        this.roomList = roomList;
    }

    public List<PeriodHardConstraint> getPeriodHardConstraintList() {
        return this.periodHardConstraintList;
    }

    public void setPeriodHardConstraintList(List<PeriodHardConstraint> periodHardConstraintList) {
        this.periodHardConstraintList = periodHardConstraintList;
    }

    public List<RoomHardConstraint> getRoomHardConstraintList() {
        return this.roomHardConstraintList;
    }

    public void setRoomHardConstraintList(List<RoomHardConstraint> roomHardConstraintList) {
        this.roomHardConstraintList = roomHardConstraintList;
    }

    @PlanningEntityCollectionProperty
    public List<Exam> getExamList() {
        return this.examList;
    }

    public void setExamList(List<Exam> examList) {
        this.examList = examList;
    }

    public HardAndSoftScore getScore() {
        return this.score;
    }

    public void setScore(HardAndSoftScore score) {
        this.score = score;
    }

    public Collection<? extends Object> getProblemFacts() {
        ArrayList<Comparable<AbstractPersistable>> facts = new ArrayList<Comparable<AbstractPersistable>>();
        facts.add(this.institutionalWeighting);
        facts.addAll(this.topicList);
        facts.addAll(this.periodList);
        facts.addAll(this.roomList);
        facts.addAll(this.periodHardConstraintList);
        facts.addAll(this.roomHardConstraintList);
        facts.addAll(this.calculateTopicConflictList());
        return facts;
    }

    private List<TopicConflict> calculateTopicConflictList() {
        ArrayList<TopicConflict> topicConflictList = new ArrayList<TopicConflict>();
        for (Topic leftTopic : this.topicList) {
            for (Topic rightTopic : this.topicList) {
                if (leftTopic.getId() >= rightTopic.getId()) continue;
                int studentSize = 0;
                for (Student student : leftTopic.getStudentList()) {
                    if (!rightTopic.getStudentList().contains(student)) continue;
                    ++studentSize;
                }
                if (studentSize <= 0) continue;
                topicConflictList.add(new TopicConflict(leftTopic, rightTopic, studentSize));
            }
        }
        return topicConflictList;
    }

    public Examination cloneSolution() {
        Examination clone = new Examination();
        clone.id = this.id;
        clone.institutionalWeighting = this.institutionalWeighting;
        clone.studentList = this.studentList;
        clone.topicList = this.topicList;
        clone.periodList = this.periodList;
        clone.roomList = this.roomList;
        clone.periodHardConstraintList = this.periodHardConstraintList;
        clone.roomHardConstraintList = this.roomHardConstraintList;
        ArrayList<Exam> clonedExamList = new ArrayList<Exam>(this.examList.size());
        for (Exam exam : this.examList) {
            Exam clonedExam = exam.clone();
            clonedExamList.add(clonedExam);
        }
        clone.examList = clonedExamList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof Examination)) {
            return false;
        }
        Examination other = (Examination)o;
        if (this.examList.size() != other.examList.size()) {
            return false;
        }
        Iterator<Exam> it = this.examList.iterator();
        Iterator<Exam> otherIt = other.examList.iterator();
        while (it.hasNext()) {
            Exam otherExam;
            Exam exam = it.next();
            if (exam.solutionEquals(otherExam = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (Exam exam : this.examList) {
            hashCodeBuilder.append(exam.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

