/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.nqueens.domain.NQueens;
import org.drools.planner.examples.nqueens.domain.Queen;
import org.drools.planner.examples.nqueens.domain.Row;
import org.drools.planner.examples.nqueens.solver.move.RowChangeMove;

public class NQueensPanel
extends SolutionPanel {
    private static final String QUEEN_IMAGE_PATH = "/org/drools/planner/examples/nqueens/swingui/queenImage.png";
    private ImageIcon queenImageIcon;

    public NQueensPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.queenImageIcon = new ImageIcon(this.getClass().getResource(QUEEN_IMAGE_PATH));
    }

    private NQueens getNQueens() {
        return (NQueens)this.solutionBusiness.getSolution();
    }

    public void resetPanel(Solution solution) {
        this.removeAll();
        NQueens nQueens = (NQueens)solution;
        int n = nQueens.getN();
        List<Queen> queenList = nQueens.getQueenList();
        this.setLayout(new GridLayout(n, n));
        for (int y = 0; y < n; ++y) {
            for (int x = 0; x < n; ++x) {
                Queen queen = queenList.get(x);
                if (queen.getColumn().getIndex() != x) {
                    throw new IllegalStateException("The queenList is not in the expected order.");
                }
                if (queen.getRow() != null && queen.getRow().getIndex() == y) {
                    JButton button = new JButton(new QueenAction(queen));
                    button.setHorizontalTextPosition(0);
                    button.setVerticalTextPosition(3);
                    this.add(button);
                    continue;
                }
                JPanel panel = new JPanel();
                panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
                Color background = (y + x) % 2 == 0 ? Color.WHITE : Color.GRAY;
                panel.setBackground(background);
                this.add(panel);
            }
        }
    }

    private class QueenAction
    extends AbstractAction {
        private Queen queen;

        public QueenAction(Queen queen) {
            super("[" + queen.getId() + "]", NQueensPanel.this.queenImageIcon);
            this.queen = queen;
        }

        public void actionPerformed(ActionEvent e) {
            List<Row> rowList = NQueensPanel.this.getNQueens().getRowList();
            JComboBox<Object> rowListField = new JComboBox<Object>(rowList.toArray());
            rowListField.setSelectedItem(this.queen.getRow());
            int result = JOptionPane.showConfirmDialog(NQueensPanel.this.getRootPane(), rowListField, "Select row", 2);
            if (result == 0) {
                Row toRow = (Row)rowListField.getSelectedItem();
                RowChangeMove move = new RowChangeMove(this.queen, toRow);
                NQueensPanel.this.solutionBusiness.doMove(move);
                NQueensPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

