/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.NurseRoster;
import org.drools.planner.examples.nurserostering.domain.ShiftAssignment;
import org.drools.planner.examples.nurserostering.domain.ShiftDate;
import org.drools.planner.examples.nurserostering.domain.WeekendDefinition;
import org.drools.planner.examples.nurserostering.solver.move.EmployeeChangeMove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NurseRosteringPanel
extends SolutionPanel {
    private static final Color HEADER_COLOR = Color.YELLOW;
    private GridLayout gridLayout = new GridLayout(0, 1);

    public NurseRosteringPanel() {
        this.setLayout(this.gridLayout);
    }

    private NurseRoster getNurseRoster() {
        return (NurseRoster)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        this.removeAll();
        NurseRoster nurseRoster = (NurseRoster)solution;
        this.gridLayout.setColumns(nurseRoster.getShiftDateList().size() + 1);
        JLabel headerCornerLabel = new JLabel("E \\ SD");
        headerCornerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        headerCornerLabel.setBackground(HEADER_COLOR);
        headerCornerLabel.setOpaque(true);
        this.add(headerCornerLabel);
        for (ShiftDate shiftDate : nurseRoster.getShiftDateList()) {
            JLabel shiftDateLabel = new JLabel(shiftDate.getLabel());
            shiftDateLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            shiftDateLabel.setBackground(HEADER_COLOR);
            shiftDateLabel.setOpaque(true);
            this.add(shiftDateLabel);
        }
        HashMap<Employee, Map<ShiftDate, EmployeeShiftDatePanel>> employeeShiftDatePanelMap = new HashMap<Employee, Map<ShiftDate, EmployeeShiftDatePanel>>();
        for (Employee employee : nurseRoster.getEmployeeList()) {
            this.createEmployeeLine(nurseRoster, employeeShiftDatePanelMap, employee);
        }
        this.createEmployeeLine(nurseRoster, employeeShiftDatePanelMap, null);
        for (ShiftAssignment shiftAssignment : nurseRoster.getShiftAssignmentList()) {
            Employee employee = shiftAssignment.getEmployee();
            EmployeeShiftDatePanel employeeShiftDatePanel = (EmployeeShiftDatePanel)((Map)employeeShiftDatePanelMap.get(employee)).get(shiftAssignment.getShiftDate());
            employeeShiftDatePanel.addShiftAssignment(shiftAssignment);
        }
    }

    private void createEmployeeLine(NurseRoster nurseRoster, Map<Employee, Map<ShiftDate, EmployeeShiftDatePanel>> employeeShiftDatePanelMap, Employee employee) {
        JLabel employeeLabel = new JLabel(employee == null ? "Unassigned" : employee.toString());
        employeeLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        employeeLabel.setBackground(HEADER_COLOR);
        employeeLabel.setOpaque(true);
        this.add(employeeLabel);
        HashMap<ShiftDate, EmployeeShiftDatePanel> shiftDatePanelMap = new HashMap<ShiftDate, EmployeeShiftDatePanel>();
        employeeShiftDatePanelMap.put(employee, shiftDatePanelMap);
        for (ShiftDate shiftDate : nurseRoster.getShiftDateList()) {
            WeekendDefinition weekendDefinition;
            EmployeeShiftDatePanel employeeShiftDatePanel = new EmployeeShiftDatePanel();
            WeekendDefinition weekendDefinition2 = weekendDefinition = employee == null ? WeekendDefinition.SATURDAY_SUNDAY : employee.getContract().getWeekendDefinition();
            if (weekendDefinition.isWeekend(shiftDate.getDayOfWeek())) {
                employeeShiftDatePanel.setBackground(Color.LIGHT_GRAY);
            }
            employeeShiftDatePanel.setToolTipText((employee == null ? "Unassigned" : "employee " + employee.getCode()) + " on dayIndex " + shiftDate.getDayIndex());
            this.add(employeeShiftDatePanel);
            shiftDatePanelMap.put(shiftDate, employeeShiftDatePanel);
        }
    }

    private class ShiftAssignmentAction
    extends AbstractAction {
        private ShiftAssignment shiftAssignment;

        public ShiftAssignmentAction(ShiftAssignment shiftAssignment) {
            super(shiftAssignment.getLabel());
            this.shiftAssignment = shiftAssignment;
        }

        public void actionPerformed(ActionEvent e) {
            List<Employee> employeeList = NurseRosteringPanel.this.getNurseRoster().getEmployeeList();
            JComboBox<Object> employeeListField = new JComboBox<Object>(employeeList.toArray());
            employeeListField.setSelectedItem(this.shiftAssignment.getEmployee());
            int result = JOptionPane.showConfirmDialog(NurseRosteringPanel.this.getRootPane(), employeeListField, "Select employee", 2);
            if (result == 0) {
                Employee toEmployee = (Employee)employeeListField.getSelectedItem();
                NurseRosteringPanel.this.solutionBusiness.doMove(new EmployeeChangeMove(this.shiftAssignment, toEmployee));
                NurseRosteringPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }

    private class EmployeeShiftDatePanel
    extends JPanel {
        public EmployeeShiftDatePanel() {
            super(new GridLayout(0, 1));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }

        public void addShiftAssignment(ShiftAssignment shiftAssignment) {
            JButton button = new JButton(new ShiftAssignmentAction(shiftAssignment));
            this.add(button);
        }
    }
}

